<?= $this->extend('guest/layouts/master') ?>

<?= $this->section('head.title') ?>
    <?=$item->title?>
<?= $this->endSection() ?>

<?= $this->section('body.breadcrumb')?>

<?=$this->endSection()?>

<?= $this->section('content') ?>
<!--#siteMain-->
<section id="siteMain" class="site-main">

    <style>
        .news-detail .item .title {
            text-align: center;
            /*text-transform: uppercase;*/
            background-color: #ddd;
            padding: 10px;
        }
        .news-detail .item .content{
            padding: 10px;
        }
        .news-detail div.row.item{
            border: #E6E6E6 1px solid;
            margin: 0 auto;
        }
        .step-news-detail{
            color: #b00020;
        }
        .news-detail div.row.button{
            padding: 10px;
        }
        .content .hit{
            padding-left: 10px;
        }
    </style>
    <div class="container">
        <!--h6 class="step-news-detail">List <i class="fas fa-angle-right"></i> Detail </h6-->

    <div class="sub07Wrap">
        <div class="wrap">
            
            <div class="subWrap01Top">
                <div class="sub_category">
                    <div class="sub_categoryName">
                        <p>HOME > <?=lang_estimate('title')?>
                    </div>
                    <div class="sub_categoryBtn">
                        <p>서브메뉴 접기 </p>
                        <span><img src="<?=asset_public('images/upbtn.png')?>" alt="접기"></span>
                    </div>
                </div>
                <div class="sub_categoryMenu on">
                    <ul>
                        <li><a href="<?=route_guest('one2one')?>">1:1 상담</a></li>
                        <li><a href="<?=route_guest('inquiry')?>">상품문의</a></li>
                        <li class="on"><a href="<?=route_guest('estimate')?>">견적문의</a></li>
                        <li><a href="<?=route_guest('deferredpay')?>">후불문의</a></li>
                        <li><a href="<?=route_guest('orderinfo')?>">주문내역</a></li>
                        <li><a href="<?=route_guest('review')?>">상품후기</a></li>
                        <li><a href="<?=route_guest('refundinfo')?>">반품문의</a></li>
                        <li><a href="<?=route_guest('news')?>">공지사항</a></li>
                    </ul>
                </div>
            </div>



            <div class="container">
                <div class="form-login">
                    <h2 class="form-title">보안 로그인</h2>
                    <form id="form" method="post" action="<?=route_guest('estimate.detailpost', $estimateId)?>">
                        <div class="form-group">
                            <label for="password" class="form-label"><?=lang_login('password')?></label>
                            <input id="password" type="password" class="form-control" name="password" aria-describedby="password"/>
                        </div>
                        <div class="form-action">
                            <button type="submit" class="btn btn-submit btn-login w-100" name="submit">입력</button>
                        </div>
                    </form>
                </div>
            </div>


        </div>
    </div>



    </div>


    <script src="<?=asset_guest_js('sweetalert.min.js')?>"></script>
    <script>
        $(document).ready(function () {        
            <?php if(session()->getFlashdata('status')) {?>
                swal({
                    title: "<?=session()->getFlashdata('status')?>",
                    text: "<?=session()->getFlashdata('status_text')?>",
                    icon: "<?=session()->getFlashdata('status_icon')?>",
                    buttons: "확인",
                });
            <?Php } ?>
        });
    </script>
</section>  
<?= $this->endSection() ?>
