<?php
use App\Helpers\AuthHelpers;
?>

<?= $this->extend('guest/layouts/master') ?>

<?= $this->section('head.title') ?>
    <?=$settingInfo->app_name?>
<?= $this->endSection() ?>


<?= $this->section('content') ?>

    <!-- 메인 팝업배너 시작-->
    <link rel="stylesheet" href="<?=asset_guest_css('mainpopup.css')?>">
    <script src="https://cpwebassets.codepen.io/assets/common/stopExecutionOnTimeout-2c7831bb44f98c1391d6a4ffda0e1fd302503391ca806e7fcc7b9b87197aec26.js"></script>
    <script src="https://cpwebassets.codepen.io/assets/editor/iframe/iframeRefreshCSS-44fe83e49b63affec96918c9af88c0d80b209a862cf87ac46bc933074b8c557d.js"></script>

    <?php 
        foreach ($popup as $key => $popups):

        $start_date = substr($popups->start_date, 0, 10); 
        $end_date = substr($popups->end_date, 0, 10);

        if ($newDate >= $start_date && $newDate <= $end_date) {
            $popupcount = $key+1;
    ?>
        <div class="main_popup<?=$popupcount?>">
            <div class="layer_cont">
                <div class="img_wrap">
                <a href="<?=$popups->goto_URL?>"><img src="<?=$popups->image_dir?>" alt="<?=$popups->title?>"></a>
                </div>
                <div class="btn_wrap">
                <!-- 오늘 하루 보지 않기 --->
                <button class="btn_today_close"><span>오늘 하루 보지 않기</span></button>
                <!-- 그냥 닫기 --->
                <button class="btn_close">close</button>
                </div>
            </div>
        </div>

        <script id="rendered-js" >
            var toggleMainPopup<?=$popupcount?> = function () {
            var handleStorage<?=$popupcount?> = {
                setStorage<?=$popupcount?>: function (name<?=$popupcount?>, exp) {
                var date<?=$popupcount?> = new Date();
                date<?=$popupcount?> = date<?=$popupcount?>.setTime(date<?=$popupcount?>.getTime() + exp * 24 * 60 * 60 * 1000);
                localStorage.setItem(name<?=$popupcount?>, date<?=$popupcount?>);
                },
                getStorage<?=$popupcount?>: function (name<?=$popupcount?>) {
                var now<?=$popupcount?> = new Date();
                now<?=$popupcount?> = now<?=$popupcount?>.setTime(now<?=$popupcount?>.getTime());
                return parseInt(localStorage.getItem(name<?=$popupcount?>)) > now<?=$popupcount?>;
                } };
            if (handleStorage<?=$popupcount?>.getStorage<?=$popupcount?>("today<?=$popupcount?>")) {
                $(".main_popup<?=$popupcount?>").removeClass("on");
            } else {
                $(".main_popup<?=$popupcount?>").addClass("on");
            }
            $(".main_popup<?=$popupcount?>").on("click", ".btn_today_close", function () {
                handleStorage<?=$popupcount?>.setStorage<?=$popupcount?>("today<?=$popupcount?>", 1);
                $(this).parents(".main_popup<?=$popupcount?>.on").removeClass("on");
            });
            $(".main_popup<?=$popupcount?>").on("click", ".btn_close", function () {
                $(this).parents(".main_popup<?=$popupcount?>.on").removeClass("on");
            });
            };
            $(function () {toggleMainPopup<?=$popupcount?>();});
        </script>
    <?php 
        }
        endforeach;
    ?>
    <!-- 메인 팝업배너 끝 -->

<section class="main_slide">
   <div class="slider-container">      
      <div class="slider">
      
            <!-- 슬라이드 쇼 -->
            <?php 
            $newDate = date("Y-m-d H:i:s");

            foreach ($bannermain as $key => $bannermains):
            // var_dump($bannermains->image_dir);

            $start_date = substr($bannermains->start_date, 0, 10); 
            $end_date = substr($bannermains->end_date, 0, 10); 

            if ($newDate >= $start_date && $newDate <= $end_date) {
            ?>
                  <div class="slide">
                     <div class="content_wrap">
                        <a href="<?=$bannermains->goto_URL?>">
                        <img src="<?=asset_public($bannermains->image_dir)?>" alt="<?=$bannermains->sub_title?>">
                        </a>
                     </div>
                  </div>
            <?php 
            }  
            endforeach; 
            ?>
            <!-- / 슬라이드 쇼 끝 -->

      </div>

      <button class="prev swiper-button-prev"></button>
      <button class="next swiper-button-next"></button>
      <div class="pagination"></div>
   </div>
</section>




<section class="main_content">
   <div class="content_wrap">

      <div class="notice">
         <div class="c_title">
            <h2>공지사항</h2>
            <a href="#" class="icon-btn"><span class="material-symbols-outlined">add</span></a>            
         </div>

         <ul class="list_style1">
            <?php foreach ($News['lists'] as $key => $news_item): ?>
               <li><a href="<?=route_guest('news.detail', $news_item->id)?>">   
                  <label class="badge_light_blue">공지</label>
                  <?php
                  echo $news_item->title;
                  ?>
               </a></li>
            <?php endforeach ?>
         </ul>
      </div>

      <div class="serviceCenter">
         <div class="c_title">
            <h2>고객센터</h2>
            <a href="#" class="icon-btn"><span class="material-symbols-outlined">add</span></a>
         </div>

         <div class="center-content">
            <div class="quick-bn">
               <p class="align-l font-light2 cmt">아래 해당 게시판으로 문의주시면 빠르고 정확한 상담이 가능해요 365</p>
               <ul>
                  <li>
                     <a href="<?=route_guest('inquiry')?>">
                     <p class="ico"><img src="<?=asset_public('images/icon-center1.png')?>" alt=""></p>
                     <p>상품문의</p>
                     </a>
                  </li>
                  <li>
                     <a href="<?=route_guest('one2one')?>">
                     <p class="ico"><img src="<?=asset_public('images/icon-center2.png')?>" alt=""></p>
                     <p>1:1상담</p>
                     </a>
                  </li>
                  <li>
                     <a href="<?=route_guest('refundinfo')?>">
                     <p class="ico"><img src="<?=asset_public('images/icon-center3.png')?>" alt=""></p>
                     <p>반품문의</p>
                     </a>
                  </li>
                  <li>
                     <a href="<?=route_guest('orderinfo')?>">
                     <p class="ico"><img src="<?=asset_public('images/icon-center4.png')?>" alt=""></p>
                     <p>세금계산서 발행</p>
                     </a>
                  </li>
               </ul>
            </div>

            <div class="center-info bg-light-blue p-1">
               <div class="info-t">
                  <p class="font-lg bold col-blue align-l">031-556-6153</p>
                  <p class="mail-info"><span class="font-light2">Email. selpa@selpasemicom.com</span> <span class="font-light2">Fax. 031-566-6153 </span></p>
               </div>
               <hr>
               <div class="info-b align-l">
                  <p>평일 : AM 09:00 ~ PM : 06:00</p>
                  <p>점심 : PM 12:00 ~ PM : 01:00 <!--span class="m_block">(매월 셋째주 목요일 : AM 11:00 ~ PM : 01:00)</span--></p>
                  <p>토, 일, 공휴일 휴무</p>
               </div>
            </div>
         </div>
      </div>

      <div class="estimate">
         <div class="c_title">
            <h2>견적요청</h2>
            <a href="#" class="icon-btn"><span class="material-symbols-outlined">add</span></a>
         </div>
         <div class="rolling-wrap">
            <ul class="list_style2 estimate-rolling">

            <?php foreach ($Estimate['lists'] as $key => $estimate_item): ?>

                     <?php
                     // $review_title = $estimate_item->title;
                     // echo mb_substr($review_title,0,15,'utf-8')."...";
                     ?>

                  <li>
                     <a href=""><p>
                     <?=\App\Helpers\DateHelper::toTimeStringYMD($estimate_item->created_at)?>
                     </p><p>
                     <?php
                     // echo preg_replace('/.(?=.$)/u','○', $estimate_item->user_name);
                     echo preg_replace('/(?<=.{1})./u','*', $estimate_item->user_name);
                     ?>
                     </p>
                     <?php 
                     if($estimate_item->situation ==1) {
                        echo "<p class='col-blue'>".lang_common('situation01')."</p>";
                     } elseif ($estimate_item->situation ==2){
                        echo "<p class='col-blue'>".lang_common('situation02')."</p>";
                     } elseif ($estimate_item->situation ==3){
                        echo "<p class='col-gray'>".lang_common('situation03')."</p>";
                     } else {
                        echo "<p class='col-blue'>".lang_common('situation00')."</p>";
                     }
                     ?>
                     </a>
                  </li>
                  <?php endforeach ?>

               <!--li><a href=""><p>2024-10-17</p><p>이지민1</p><p class="col-blue">신청접수</p></a></li>
               <li><a href=""><p>2024-10-17</p><p>이지민2</p><p class="col-blue">신청접수</p></a></li>
               <li><a href=""><p>2024-10-17</p><p>이지민3</p><p class="col-gray">답변완료</p></a></li>
               <li><a href=""><p>2024-10-17</p><p>이지민4</p><p class="col-gray">답변완료</p></a></li>
               <li><a href=""><p>2024-10-17</p><p>이지민5</p><p class="col-gray">답변완료</p></a></li>
               <li><a href=""><p>2024-10-17</p><p>이지민6</p><p class="col-gray">답변완료</p></a></li>
               <li><a href=""><p>2024-10-17</p><p>이지민7</p><p class="col-gray">답변완료</p></a></li>
               <li><a href=""><p>2024-10-17</p><p>홍길동1</p><p class="col-gray">답변완료</p></a></li>
               <li><a href=""><p>2024-10-17</p><p>홍길동2</p><p class="col-gray">답변완료</p></a></li>
               <li><a href=""><p>2024-10-17</p><p>홍길동3</p><p class="col-gray">답변완료</p></a></li>
               <li><a href=""><p>2024-10-17</p><p>홍길동4</p><p class="col-gray">답변완료</p></a></li>
               <li><a href=""><p>2024-10-17</p><p>홍길동5</p><p class="col-gray">답변완료</p></a></li>
               <li><a href=""><p>2024-10-17</p><p>홍길동6</p><p class="col-gray">답변완료</p></a></li>
               <li><a href=""><p>2024-10-17</p><p>이지민1</p><p class="col-blue">신청접수</p></a></li>
               <li><a href=""><p>2024-10-17</p><p>이지민2</p><p class="col-blue">신청접수</p></a></li>
               <li><a href=""><p>2024-10-17</p><p>이지민3</p><p class="col-gray">답변완료</p></a></li>
               <li><a href=""><p>2024-10-17</p><p>이지민4</p><p class="col-gray">답변완료</p></a></li>
               <li><a href=""><p>2024-10-17</p><p>이지민5</p><p class="col-gray">답변완료</p></a></li>
               <li><a href=""><p>2024-10-17</p><p>이지민6</p><p class="col-gray">답변완료</p></a></li-->

            </ul>
         </div>
      </div>

   </div>
</section>


<!--/#siteHeroBanner-->
<?= $this->endSection() ?>
