<?= $this->extend('guest/layouts/master') ?>

<?= $this->section('head.title') ?>
    <?=lang_inquiry('title')?>
<?= $this->endSection() ?>

<?= $this->section('body.breadcrumb')?>

<?=$this->endSection()?>

<?= $this->section('content') ?>
    <!--#siteMain-->
<!-- product details top info s -->
<section class="sub_wrap">
    <div class="content_wrap prd-list-wrap">
<!------------------------------------------------------------------------------------------------------------------->

        <nav class="breadcrumb" style='background-color: #ffffff;'>
            <ul>
            <li><a href='<?=route_guest('home')?>'><img src='<?=asset_public('images/ico-home.png')?>' alt=''></a></li>
            <li><a href="#">마이페이지</a></li>
                <li><a href="#"><?=lang_inquiry('title')?></a></li>                
            </ul>            
        </nav>

        <div class="prd-category mt-2">            
            <select name="" id="" class="prd-cate-mo">
                <option value=""><a href="<?=route_guest('one2one')?>">1:1 상담</a></option>
                <option value=""><a href="<?=route_guest('inquiry')?>">상품문의</a></option>
                <option value=""><a href="<?=route_guest('estimate')?>">견적문의</a></option>
                <!--option value=""><a href="<?=route_guest('deferredpay')?>">후불문의</a></option-->
                <option value=""><a href="<?=route_guest('orderinfo')?>">주문내역</a></option>
                <!--option value=""><a href="<?=route_guest('review')?>">상품후기</a></option-->
                <option value=""><a href="<?=route_guest('refundinfo')?>">반품문의</a></option>
                <!--option value=""><a href="<?=route_guest('news')?>">공지사항</a></option-->
            </select>

            <div class="prd-cate-pc">
                <div class="category-toggle">                
                마이페이지
                </div>
                <div class="category-box">
                    <ul>
                        <li class="prd_cate_item"><a href="<?=route_guest('one2one')?>">1:1 상담</a></li>
                        <li class="prd_cate_item"><a href="<?=route_guest('inquiry')?>" class="active">상품문의</a></li>
                        <li class="prd_cate_item"><a href="<?=route_guest('estimate')?>">견적문의</a></li>
                        <!--li class="prd_cate_item"><a href="<?=route_guest('deferredpay')?>">후불문의</a></li-->
                        <li class="prd_cate_item"><a href="<?=route_guest('orderinfo')?>">주문내역</a></li>
                        <!--li class="prd_cate_item"><a href="<?=route_guest('review')?>">상품후기</a></li-->
                        <li class="prd_cate_item"><a href="<?=route_guest('refundinfo')?>">반품문의</a></li>
                        <!--li class="prd_cate_item"><a href="<?=route_guest('news')?>">공지사항</a></li-->
                    </ul>
                </div>
            </div>
        </div>

        <!-- 주문 상품정보 s -->
        <div class="border-light-box">
        <div class="sub_title"><?=lang_inquiry('title')?></div>

        <div class="order-form">
            <div class="form-gp">
                <div class="d-flex g-2">
                    <div style="width: 100%;">
                        <form method="get" action="<?=route_guest('inquiry')?>">
                        <input placeholder="<?=lang_inquiry('title')?> 검색" name="title" value="<?=$title?>" style="width: 80%;">
                        <button type="submit" class="btn font-xsm btn-outline-white float-r">검색</button>
                        </form>
                    </div>
                </div>
                <div class="d-flex g-2">
                    <div style="width: 100%;">
                        <div class="g-2 align-r">
                            <ul class="prd-list-align">
                                <li class="align-item">전체 (<?=$totalRowStr?>)</li>
                                <li class="align-item">답변대기 (<?=$situation1?>)</li>
                                <li class="align-item">답변완료 (<?=$situation3?>)</li>
                            </ul>

                            <select name="" id="" class="prd-align-mo prd-list-align-mo">
                                <option value="">전체 (<?=$totalRowStr?>)</option>
                                <option value="">답변대기 (<?=$situation1?>)</option>
                                <option value="">답변완료 (<?=$situation3?>)</option>
                            </select>
                        </div>
                    </div>
                </div>
                <!--a class="btn font-xsm btn-blue float-r" href="<?=route_guest('inquiry.show_create')?>"><?=lang_common('create')?></a-->
            </div>
        </div>


        <div class="prd-linelist">
        <table>
            <thead>
                <tr>
                    <td class="info1"><?=lang_contact('news_no')?></td>
                    <td class="info2"><?=lang_common('situation')?></td>
                    <td class="desc"><?=lang_contact('news_title')?></td>
                    <td class="info2"><?=lang_contact('news_id')?></td>
                    <td class="info1"><?=lang_contact('news_date')?></td>

                </tr>
                </tr>
            </thead>

            <tbody>
                <?php foreach ($lists as $key => $item): ?>
                    <tr>
                        <td data-label="<?=lang_contact('news_no')?>" class="info1"><?=show_no_row($key+1, $perPage, $currentPage)?></td>
                        <!--td data-label="<?=lang_contact('news_category')?>" class="info1"><?=$item->category_name?></td-->
                        <td data-label="<?=lang_common('situation')?>" class="info2">
                            <?php 
                            if($item->situation ==1) {
                                echo lang_common('situation01');
                            } elseif ($item->situation ==2){
                                echo lang_common('situation02');
                            } elseif ($item->situation ==3){
                                echo lang_common('situation03');
                            } else {
                                echo lang_common('situation00');
                            }
                            ?>
                        </td>
                        <td data-label="<?=lang_contact('news_title')?>" class="desc">
                            <?php if($item->password): ?>
                                <a href="<?=route_guest('inquiry.detaillogin', $item->id)?>"><?=$item->title?></a>
                            <?php else : ?>
                                <a href="<?=route_guest('inquiry.detail', $item->id)?>"><?=$item->title?></a>
                            <?php endif;?>                        
                        </td>
                        <td data-label="<?=lang_contact('news_id')?>" class="info2">
                        <?php
                            echo preg_replace('/(?<=.{1})./u','*', $item->user_name);
                        ?>
                        </td>
                        <td data-label="<?=lang_contact('news_date')?>" class="info1"><?=\App\Helpers\DateHelper::toTimeString($item->created_at,'yyyy-MM-dd')?></td>
                        <!--td class="info1"><?=\App\Helpers\NumberHelper::format($item->hit_number, true)?></td-->
                    </tr>
                <?php endforeach; ?>
                <?php if(count($lists) == 0): ?>
                    <tr>
                        <td colspan="5"><?=lang_common('no_data')?></td>
                    </tr>
                <?php endif;?>
            </tbody>
        </table>
        </div>

<!------------------------------------------------------------------------------------------------------------------->
    </div>
<!---------------------------------------------------------------------------------------------------------------->

    <div class="row">
        <div class="col-12">
            <?= $pager->links() ?>
        </div>
    </div>

</section>
<!--product details top info e-->
<!--/#siteMain-->
<!---------------------------------------------------------------------------------------------->
        
    <script src="<?=asset_guest_js('sweetalert.min.js')?>"></script>
    <script>
        $(document).ready(function () {        
            <?php if(session()->getFlashdata('status')) {?>
                swal({
                    title: "<?=session()->getFlashdata('status')?>",
                    text: "<?=session()->getFlashdata('status_text')?>",
                    icon: "<?=session()->getFlashdata('status_icon')?>",
                    buttons: "확인",
                });
            <?Php } ?>
        });
    </script>

    <script>
        $(function () {        
            $('.myMenu ul li').on('mouseenter mouseleave', function () {
                $(this).children('ul').stop(true, false, true).slideToggle(10);
            });
        });

        $(document).ready(function() {
            $('.category-toggle').click(function() {
                $('.category-box').slideToggle(300); // 슬라이드 애니메이션 효과로 펼치고 접기
                $(this).toggleClass('on');
            });
        });

        /* prd category */    
        $(".prd_cate_item a").click(function(){
            $(".prd_cate_item a").removeClass("active");
            //this는 함수를 실행하게 만든 그 클릭한 요소다!
            $(this).addClass("active");//그 요소에게 효과주고        
        });

        /* 상품 정렬 */
        $(".align-item a").click(function(){
            $(".align-item a").removeClass("active");
            //this는 함수를 실행하게 만든 그 클릭한 요소다!
            $(this).addClass("active");//그 요소에게 효과주고        
        });
        
    </script>
<!---------------------------------------------------------------------------------------------->
<?= $this->endSection() ?>
