<?= $this->extend('guest/layouts/master') ?>

<?= $this->section('head.title') ?>
<?=lang_inquiry('title')?>
<?= $this->endSection() ?>

<?= $this->section('body.breadcrumb')?>

<?=$this->endSection()?>

<?= $this->section('body.js') ?>
    <script src="<?=asset_guest_js('lte/bootstrap-switch.min.js')?>"></script>
    <script src="<?=asset_guest_js('lte/bs-custom-file-input.min.js')?>"></script>
    <script type="text/javascript">
        $("input[data-bootstrap-switch]").each(function(){
            $(this).bootstrapSwitch('state', $(this).prop('checked'));
        });
        $(document).ready(function () {
            bsCustomFileInput.init();
            $('a.button-add').on('click',function(){
                var divParent = $(this).closest('div.file_upload');
                inputs = divParent.find('div.file_item');
                $.each(inputs,function () {
                    if($(this).hasClass('hide')){
                        $(this).removeClass('hide');
                        return false;
                    }
                });

            });

            $('a.button-delete').on('click',function(){
                var divParent = $(this).closest('div.file_item');
                divParent.find('input[type=file]').val('');
                divParent.find('input[type=file]').removeClass('is-invalid');
                divParent.find('span.is-invalid').remove();
                divParent.find('label').html('Choose file');
                divParent.addClass('hide');
            });
        });
    </script>
<?= $this->endSection() ?>

<?= $this->section('content') ?>
    <!--#siteMain-->


    <section id="siteMain" class="site-main">

    <style>
        .news-detail .item .title {
            text-align: center;
            /*text-transform: uppercase;*/
            background-color: #ddd;
            padding: 10px;
        }
        .news-detail .item .content{
            padding: 10px;
        }
        .news-detail div.row.item{
            border: #E6E6E6 1px solid;
            margin: 0 auto;
        }
        .step-news-detail{
            color: #b00020;
        }
        .news-detail div.row.button{
            padding: 10px;
        }
        .content .hit{
            padding-left: 10px;
        }
    </style>
    <div class="container">
        <!--h6 class="step-news-detail">List <i class="fas fa-angle-right"></i> Detail </h6-->

    <div class="sub07Wrap">
        <div class="wrap">
    
            <div class="subWrap01Top">
                <div class="sub_category">
                    <div class="sub_categoryName">
                        <p>HOME > <?=lang_inquiry('title')?>
                    </div>
                    <div class="sub_categoryBtn">
                        <p>서브메뉴 접기 </p>
                        <span><img src="<?=asset_public('images/upbtn.png')?>" alt="접기"></span>
                    </div>
                </div>
                <div class="sub_categoryMenu on">
                    <ul>
                        <li><a href="<?=route_guest('one2one')?>">1:1 상담</a></li>
                        <li class="on"><a href="<?=route_guest('inquiry')?>">상품문의</a></li>
                        <li><a href="<?=route_guest('estimate')?>">견적문의</a></li>
                        <li><a href="<?=route_guest('deferredpay')?>">후불문의</a></li>
                        <li><a href="<?=route_guest('orderinfo')?>">주문내역</a></li>
                        <li><a href="<?=route_guest('review')?>">상품후기</a></li>
                        <li><a href="<?=route_guest('refundinfo')?>">반품문의</a></li>
                        <li><a href="<?=route_guest('news')?>">공지사항</a></li>
                    </ul>
                </div>
            </div>
            

            <!---------------------------------------------------------------------------------------------------------------->


            <div class="order_ListTdWrap">
                <?php if (!$lists) :?>
                <div class="order_List mb40">
                    <div class="order_ListTdWrap">
                        <div class="order_Price mb40">
                            <div class="order_TitleWrap">
                                <div class="flex_sb">
                                    <div class="sumcount">
                                        상품문의 하시는 제품이 없습니다.
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="sub04LastBtn">
                        <ul>
                            <li><a href="<?=route_guest('home')?>"><button class="sub04payBtn" type="button"><span>확인</span></button></a></li>
                        </ul>
                    </div>

                </div>
                <?php else: ?>
                <form id="form-inq" name="user_form" method="post" action="<?=route_guest('inquiry.create')?>" enctype="multipart/form-data">
                <div class="order_List mb40">
                <div class="order_ListTh">
                    <ul> 
                        <li class="order_ListTh01">제품사진</li>
                        <li class="order_ListTh02">주문상품</li>
                        <li class="order_ListTh05">단가</li>
                        <li class="order_ListTh05">견적수량</li>
                        <li class="order_ListTh06">수량변경</li>
                        <li class="order_ListTh08">
                        <div class="trashIcon"><img src="<?=asset_public('images/trash-bin.png')?>" alt="삭제"></div>
                        </li>
                    </ul>
                </div>

                <?php $i = 1; ?>

                <?php foreach($lists as $item){?>
                <?php 
                  $item_price = $item->nowinfo['selling_price1'];
                  $amount_price = $item_price * $item->qty;
                  $price_vat = $amount_price*0.1;
                  $total_price = $amount_price+$price_vat;
                ?>
                    <div class="order_ListTd">
                        <div class="order_photo">

                        <input type="hidden" name="inquiry_id<?=$i?>" value="<?=$item->inquiry_id?>">
                        <input type="hidden" name="inquiry_code<?=$i?>" value="<?=$item->inquiry_code?>">
                        <input type="hidden" name="member_id<?=$i?>" value="<?=$item->member_id?>">
                        <input type="hidden" name="part_number<?=$i?>" value="<?=$item->nowinfo['part_number']?>"/>
                        <input type="hidden" name="stock_location<?=$i?>" value="<?=$item->nowinfo['stock_location']?>"/>
                        <input type="hidden" name="delivery_code<?=$i?>" value="<?=$item->nowinfo['delivery_code']?>"/>
                        <input type="hidden" name="product_code<?=$i?>" value="<?=$item->nowinfo['product_code']?>"/>
                        <input type="hidden"  name="p_num<?=$i?>" value="<?=$item->qty?>"/>
                        <input type="hidden" name="price<?=$i?>" id="p_price<?=$i?>" class="p_price" value="<?=$item_price?>">

                        <?php if(isset($item->nowinfo['image_dir']) && $item->nowinfo['image_dir'] != ''): ?>
                            <?php if(isset($item->nowinfo['api_flg']) && $item->nowinfo['api_flg'] == '1'): ?>
                                <img src="<?=$item->nowinfo['image_dir']?>"/>
                            <?php else : ?>
                                <img src="<?=asset_public($item->nowinfo['image_dir'])?>"/>
                            <?php endif; ?>
                        <?php else : ?>
                            <img src="<?=asset_public('images/no_image_available.jpg')?>"/>
                        <?php endif; ?>
                        </div>
                        <div class="order_listText">
                            <div class="flex_sb">
                                <div>
                                    <p class="subWrap01ContsName02_sub01">
                                    <?php echo $item->name;?>
                                    </p>
                                    <p class="subWrap01ContsName02_sub02">
                                    <?php echo $item->part_number;?>
                                    </p>
                                </div>
                                <div class="subWrap01subTag01">
                                    <span>
                                    <?php foreach ($stocklocationcategorys as $stock_location): ?>
                                        <?php if($stock_location->location_id == $item->nowinfo['stock_location']) echo $stock_location->location_info;?>
                                    <?php endforeach; ?>
                                    </span>
                                </div>
                            </div>
                            <p class="subWrap01ContsName02_sub03">
                            <?=$item->nowinfo['product_code']?> / <?=$item->nowinfo['part_number_sequence']?>
                            </p>
                            <input type="hidden" name="product_code<?=$i?>" value="<?=$item->nowinfo['product_code']?>"/>
                            <div class="subWrap01ContsName02_sub04">
                                <p>
                                <?php
                                echo mb_strimwidth($item->nowinfo['brief_description'],'0',60,'...','utf-8');
                                ?>
                                <br>
                                관련 부품 : <?=$item->nowinfo['product_related']?>
                                </p>
                            </div>
                        </div>
                        <div class="order_ListTd05">
                            <span class="order_ListPrice"><?=number_format($item_price)?>원</span>
                        </div>
                        <div class="order_ListTd05">
                            <?php echo $item->qty;?>
                        </div>
                        <div class="order_ListTd06">
                            <button class="btn btn-warning" type="button" onclick="edit_inquiry(<?php echo $item->inquiry_id;?>)">변경</button>
                        </div>
                        <!--div class="order_ListTd05">
                            <span class="order_ListPrice"><?=number_format($amount_price)?>원</span>
                        </div>
                        <div class="order_ListTd06">
                            <span class="order_ListPrice"><?=number_format($price_vat)?>원</span>
                        </div>
                        <div class="order_ListTd07">
                            <span class="order_ListPrice"><?=number_format($total_price)?>원</span>
                        </div-->
                        <div class="order_ListTd08">
                          <button onclick="delete_inquiry(<?php echo $item->inquiry_id;?>)">
                            <img src="<?=asset_public('images/trash-bin.png')?>" alt="삭제">
                          </button>
                        </div>
                    </div>

                    <?php $i++; ?>
                    <?php }?>

                </div>
 
                <?php endif;?>

  <!-------------------------------------------------------------------------------------------------------------------->


            <div class="order_List inquiry mb40 ">
                <div class="order_ListTh inquiry">
                    <ul>
                        <li class="order_ListTh01"><?=lang_common('create')?></li>
                        <li class="order_ListTh01"> <span> </span></li>                   
                    </ul>
                </div>
            </div>

            <div class="inquiry">
                <div class="inquiryT">
                
                    <div class="inquiryWrap">
                        <div class="inquiryLable">
                            <p><?=lang_common('user_name')?><span class="color-red">*</span></p>
                        </div>
                        <div class="col-md-10">
                            <input class="form-control" id="text-input" type="text" name="user_name" value="<?=old_value('name', $memberName)?>" placeholder="<?=lang_common('user_name')?>">
                        </div>
                    </div>

                    <div class="inquiryWrapE">
                        <div class="inquiryWrap">
                            <div class="inquiryLable">
                                <p><?=lang_common('user_email')?><span class="color-red">*</span></p>
                            </div>
                            <div class="col-md-10">
                                <input class="form-control" id="text-input" type="email" name="user_email" value="<?=old_value('email', $memberEmail)?>" placeholder="<?=lang_common('user_email')?>">
                            </div>
                        </div>

                        <div class="inquiryWrap">
                            <div class="inquiryLable">
                            <p><?=lang_common('reply_emeil')?></p>
                            </div>
                            <div class="inquiryText">
                            <input <?=!empty(old('replyemeil_chk')) ? 'checked': ''?> class="form-check-input" type="checkbox" name="replyemeil_chk" value="1" id="replyemeil_chk">
                            <?=lang_common('reply_note')?>
                            </div>
                        </div>
                    </div>
                    <div class="inquiryWrap">
                        <div class="inquiryLable">
                            <p><?=lang_common('user_phone')?><span class="color-red">*</span></p>
                        </div>
                        <div class="col-md-10">
                            <input class="form-control" id="text-input" type="text" name="user_phone" value="<?=old_value('phone', $memberPhone)?>" placeholder="<?=lang_common('user_phone')?>">
                        </div>
                        <input class="form-control" id="text-input" type="hidden" name="member_code" value="<?=old_value('member_code', $memberCode)?>">
                    </div>

                    <div class="inquiryWrap">
                        <div class="inquiryLable">
                            <p><?=lang_common('category')?></p>
                        </div>
                        <div class="col-md-10">
                            <select class="form-control" name="category_id">
                                <?php foreach ($categories as $category): ?>
                                    <option value="<?=$category->category_id?>">
                                        <?=$category->category_name?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                    <div class="inquiryWrapE">
                        <div class="inquiryWrap">
                            <div class="inquiryLable">
                                <p><?=lang_contact('news_title')?><span class="color-red">*</span></p>
                            </div>
                            <div class="col-md-7">
                                <input class="form-control" id="text-input" type="text" name="title" placeholder="<?=lang_common('title')?>">
                            </div>
                        </div>
                        <div class="inquiryWrap">
                            <div class="inquiryLable">
                                <p>비밀번호</p>
                            </div>
                            <div class="inquiryText">
                                <input class="form-control" id="text-input" type="password" name="password" value="" placeholder="비밀번호를 등록하면 비밀글로 지정됩니다.">
                            </div>
                        </div>
                    </div>
                    <!--div class="inquiryWrap">
                        <div class="inquiryLableFile">
                            <p><?=lang_common('file_upload')?></p>
                        </div>
                        <div class="col-md-10">
                            <div class="inquiryTextFile file_upload">
                                <p>
                                <?php for($i =1 ; $i <= $maxFiles ; $i ++): ?>
                                    <div class="input-group pb-2 file_item <?php if($i > 1) echo 'hide'?>">
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" id="files_<?=$i?>" name="files_<?=$i?>" maxsizeMb="3" accept="image/*,.pdf,.xlsx,.xls,application/vnd.openxmlformats-officedocument.spreadsheetml.sheet,application/vnd.ms-excel, application/vnd.ms-excel,application/pdf">
                                            <label class="custom-file-label" for="files_<?=$i?>">Choose file</label>
                                        </div>
                                        <div class="file_action">
                                            <?php if($i > 1): ?>
                                                <a href="javascript:void(0)" class="button-delete color-red">
                                                    <i class="fa fa-minus-square"></i>
                                                </a>
                                            <?php else: ?>
                                                <a href="javascript:void(0)" class="button-add">
                                                    <i class="fas fa-plus-circle"></i>
                                                </a>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                <?php endfor; ?>
                                <span class="help-block">
                                    <code>
                                        <i class="fa fa-exclamation" aria-hidden="true"></i>
                                        <?=lang_common('file_upload_note')?>
                                    </code>
                                </span>
                                </p>
                            </div>
                        </div>
                    </div-->
                    
                    <div class="inquiryWrapD">
                            <div class="inquiryLable100">
                                <p><?=lang_common('question')?></p>
                            </div>
                    </div>
                </div>

                <div class="inquiryContents answerinquiry">
                    <p>
                    <textarea class="form-control" id="content" name="content" rows="8"></textarea>
                    </p>
                </div>

            </div>

            <div class="inquirybtnList">
                <ul>
                    <!--li><a href="#">이전내용</a></li-->
                    <li class="inquiryList"><button type="submit"><?=lang_common('create')?></button></li>
                    <!--li><a href="#">다음내용</a></li-->
                </ul>
            </div>
        </form>

        </div>

    </div>

    </div>



<script type="text/javascript" src="https://code.jquery.com/jquery-3.5.1.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/js/bootstrap.min.js"></script>
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.20/css/jquery.dataTables.min.css">
    <script src="https://cdn.datatables.net/1.10.20/js/jquery.dataTables.min.js" type="text/javascript"></script>

    <script type="text/javascript">
        
    $(document).ready( function () {
        $('#table_id').DataTable();
    } );
        var save_method; //for save method string
        var table;
    
        function edit_inquiry(id)
        {
        save_method = 'update';
        $('#form')[0].reset(); // reset form on modals
        <?php header('Content-type: application/json'); ?>
        //Ajax Load data from ajax
        $.ajax({
            url:"<?php echo base_url('/InquiryModify/ajax_edit/'); ?>/" + id,
            type: "GET",
            dataType: "JSON",
            success: function(data)
            {
                console.log(data);
    
                $('[name="inquiry_id"]').val(data.inquiry_id);
                $('[name="part_number"]').val(data.part_number);
                $('[name="name"]').val(data.name);
                $('[name="qty"]').val(data.qty);
                $('[name="price"]').val(data.price);
    
                $('#modal_form').modal('show'); // show bootstrap modal when complete loaded
                $('.modal-title').text('수량변경'); // Set title to Bootstrap modal title
    
            },
            error: function (jqXHR, textStatus, errorThrown)
            {
                console.log(jqXHR);
                alert('Error get data from ajax');
            }
        });
        }

        function save()
        {
        var url;

        url = "<?php echo base_url('/InquiryModify/inquiry_update'); ?>";

        // ajax adding data to database
            $.ajax({
                url : url,
                type: "POST",
                data: $('#form').serialize(),
                dataType: "JSON",
                success: function(data)
                {
                //if success close modal and reload ajax table
                $('#modal_form').modal('hide');
                location.reload();// for reload a page
                },
                error: function (jqXHR, textStatus, errorThrown)
                {
                    alert('Error adding / update data');
                }
            });
        }

        function delete_inquiry(id)
        {
        if(confirm('이 데이터를 삭제하시겠습니까?'))
        {
            // ajax delete data from database
            $.ajax({
                url:"<?php echo base_url('/InquiryModify/inquiry_delete'); ?>/"+id,
                type: "POST",
                dataType: "JSON",
                success: function(data)
                {
                    
                location.reload();
                },
                error: function (jqXHR, textStatus, errorThrown)
                {
                    alert('Error deleting data');
                }
            });
    
        }
        }
    
    </script>

    <!-- Bootstrap modal -->
        <div class="modal fade" id="modal_form" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
        <div class="modal-header">
        <h3 class="modal-title">Cart Form</h3>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
        </div>
        <div class="modal-body form">
            <form action="#" id="form" class="form-horizontal">
            <input type="hidden" value="" name="inquiry_id"/>
            <div class="form-body">
                <div class="form-group">
                <label class="control-label col-md-3">제품명</label>
                <div class="col-md-9">
                    <input name="part_number" placeholder="Part Number" disabled class="form-control" type="text">
                </div>
                </div>
                <div class="form-group">
                <label class="control-label col-md-3">브랜드</label>
                <div class="col-md-9">
                    <input name="name" placeholder="Manufacturer" disabled class="form-control" type="text">
                </div>
                </div>
                <!--div class="form-group">
                <label class="control-label col-md-3">단가</label>
                <div class="col-md-9">
                    <input name="price" placeholder="Price" disabled class="form-control" type="text">
                </div>
                </div-->
                <div class="form-group">
                <label class="control-label col-md-3">변경수량</label>
                <div class="col-md-9">
                        <input name="qty" placeholder="Quantity" class="form-control" type="text">
                </div>
                </div>
            </div>
            </form>
            </div>
            <div class="modal-footer">
                <button type="button" id="btnSave" onclick="save()" class="btn btn-primary">수정</button>
                <button type="button" class="btn btn-danger" data-dismiss="modal">취소</button>
            </div>
            </div><!-- /.modal-content -->
        </div><!-- /.modal-dialog -->
        </div><!-- /.modal -->
    <!-- End Bootstrap modal -->

</section>  
<?= $this->endSection() ?>
