<?php
use App\Helpers\AuthHelpers;
?>

<?= $this->extend('guest/layouts/master') ?>

<?= $this->section('head.title') ?>
    <?=$item->title?>
<?= $this->endSection() ?>

<?= $this->section('body.breadcrumb')?>

<?=$this->endSection()?>

<?= $this->section('content') ?>
    <!--#siteMain-->
<!-- product details top info s -->
<section class="sub_wrap">
    <div class="content_wrap prd-list-wrap">
<!------------------------------------------------------------------------------------------------------------------->

        <nav class="breadcrumb" style='background-color: #ffffff;'>
            <ul>
            <li><a href='<?=route_guest('home')?>'><img src='<?=asset_public('images/ico-home.png')?>' alt=''></a></li>
            <li><a href="#">마이페이지</a></li>
                <li><a href="#"><?=lang_inquiry('title')?></a></li>                
            </ul>            
        </nav>

        <div class="prd-category mt-2">            
            <select name="" id="" class="prd-cate-mo">
                <option value=""><a href="<?=route_guest('one2one')?>">1:1 상담</a></option>
                <option value=""><a href="<?=route_guest('inquiry')?>">상품문의</a></option>
                <option value=""><a href="<?=route_guest('estimate')?>">견적문의</a></option>
                <!--option value=""><a href="<?=route_guest('deferredpay')?>">후불문의</a></option-->
                <option value=""><a href="<?=route_guest('orderinfo')?>">주문내역</a></option>
                <!--option value=""><a href="<?=route_guest('review')?>">상품후기</a></option-->
                <option value=""><a href="<?=route_guest('refundinfo')?>">반품문의</a></option>
                <!--option value=""><a href="<?=route_guest('news')?>">공지사항</a></option-->
            </select>

            <div class="prd-cate-pc">
                <div class="category-toggle">                
                마이페이지
                </div>
                <div class="category-box">
                    <ul>
                        <li class="prd_cate_item"><a href="<?=route_guest('one2one')?>">1:1 상담</a></li>
                        <li class="prd_cate_item"><a href="<?=route_guest('inquiry')?>" class="active">상품문의</a></li>
                        <li class="prd_cate_item"><a href="<?=route_guest('estimate')?>">견적문의</a></li>
                        <!--li class="prd_cate_item"><a href="<?=route_guest('deferredpay')?>">후불문의</a></li-->
                        <li class="prd_cate_item"><a href="<?=route_guest('orderinfo')?>">주문내역</a></li>
                        <!--li class="prd_cate_item"><a href="<?=route_guest('review')?>">상품후기</a></li-->
                        <li class="prd_cate_item"><a href="<?=route_guest('refundinfo')?>">반품문의</a></li>
                        <!--li class="prd_cate_item"><a href="<?=route_guest('news')?>">공지사항</a></li-->
                    </ul>
                </div>
            </div>
        </div>

<!------------------------------------------------------------------------------------------------------------------->
    <!--/div>
</section-->
<!-- product details top info e -->

<!---------------------------------------------------------------------------------------------------------------->

    <?php if ($item->password) { ?>

    <div class="border-light-box">
        <div class="border-light-box order-form">
            <div class="sub_title d-flex">문의상품정보</div>
            <table class="prd-linelist">
                <thead>
                    <tr>
                    <td class="image">Image</td>
                    <td class="info1">Mfr.Part#</td>
                    <td class="info2">Manufacturer</td>
                    <td class="desc">Description</td>
                    <td class="info3">MOQ/MPQ/PKG</td>
                    <td class="info4">Priceing</td>
                    </tr>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td class="image">
                            <a href="<?=route_guest('sale.detail', $productinfo->product_code)?>">
                            <?php if(isset($productinfo->image_dir) && $productinfo->image_dir != ''): ?>
                                <?php if(isset($productinfo->api_flg) && $productinfo->api_flg == '1'): ?>
                                    <img src="<?=$productinfo->image_dir?>"/>
                                <?php else : ?>
                                    <img src="<?=asset_public($productinfo->image_dir)?>"/>
                                <?php endif; ?>
                            <?php else : ?>
                                <img src="<?=asset_public('images/no_image_available.jpg')?>"/>
                            <?php endif; ?>
                            </a>
                        </td>
                        <td data-label="Mfr.Part#" class="info1">
                            <a href="<?=route_guest('sale.detail', $productinfo->product_code)?>">
                            <?=$productinfo->part_number?>
                            </a>
                            <input id="name" type="hidden" class="form-control" name="part_number" value="<?=$productinfo->part_number?>" placeholder="<?=lang_cart('part_number')?>" aria-describedby="part_number"/>
                        </td>
                        <td data-label="Manufacturer" class="info2"><?=$productinfo->name?></td>
                        <?php
                            $brief_description = $productinfo->brief_description;
                            $prd_description = explode('|^|', $brief_description);
                        ?>
                        <td data-label="Description" class="desc"><?=$prd_description[0]?>, <?=$prd_description[1]?></td>
                        <td data-label="MOQ/MPQ/PKG" class="info3">                                    
                            <ul>
                                <li>MOQ : <?=\App\Helpers\NumberHelper::format($productinfo->moq, true)?></li>
                                <li>MPQ : <?=\App\Helpers\NumberHelper::format($productinfo->mpq, true)?></li>
                                <li>PKG : <?=$productinfo->packing_name?>(<?=$productinfo->packing_code?>)</li>
                            </ul>  
                        </td>
                        <td data-label="Priceing" class="info4">
                            <ul>
                                <?php 
                                if($productinfo->unit_mini_quantity1 > 0) {
                                echo '<li style="text-align: right;">'.\App\Helpers\NumberHelper::format($productinfo->unit_mini_quantity1, true).'개 ~';
                                echo ' '.\App\Helpers\NumberHelper::format($productinfo->selling_price1, true).''.lang_sale('price_unit').'</li>';
                                }
                                if($productinfo->unit_mini_quantity2 > 0) {
                                echo '<li style="text-align: right;">'.\App\Helpers\NumberHelper::format($productinfo->unit_mini_quantity2, true).'개 ~';
                                echo ' '.\App\Helpers\NumberHelper::format($productinfo->selling_price2, true).''.lang_sale('price_unit').'</li>';
                                }
                                if($productinfo->unit_mini_quantity3 > 0) {
                                echo '<li style="text-align: right;">'.\App\Helpers\NumberHelper::format($productinfo->unit_mini_quantity3, true).'개 ~';
                                echo ' '.\App\Helpers\NumberHelper::format($productinfo->selling_price3, true).''.lang_sale('price_unit').'</li>';
                                }

                                if($productinfo->unit_mini_quantity4 > 0) {
                                echo '<li style="text-align: right;">'.\App\Helpers\NumberHelper::format($productinfo->unit_mini_quantity4, true).'개 ~';
                                echo ' '.\App\Helpers\NumberHelper::format($productinfo->selling_price4, true).''.lang_sale('price_unit').'</li>';
                                }
                                if($productinfo->unit_mini_quantity5 > 0) {
                                echo '<li style="text-align: right;">'.\App\Helpers\NumberHelper::format($productinfo->unit_mini_quantity5, true).'개 ~';
                                echo ' '.\App\Helpers\NumberHelper::format($productinfo->selling_price5, true).''.lang_sale('price_unit').'</li>';
                                }
                                if($productinfo->unit_mini_quantity6 > 0) {
                                echo '<li style="text-align: right;">'.\App\Helpers\NumberHelper::format($productinfo->unit_mini_quantity6, true).'개 ~';
                                echo ' '.\App\Helpers\NumberHelper::format($productinfo->selling_price6, true).''.lang_sale('price_unit').'</li>';
                                }
                                ?>
                            </ul> 
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>

        <div class="border-light-box order-form">
            <div class="sub_title d-flex"><?=lang_inquiry('title')?></div>
            <div class="sub_title"><?=$item->title?></div>
            <div class="form-gp">
                <div class="d-flex g-2">
                    <label for=""><?=lang_contact('news_id')?></label>
                    <?=$item->user_name?>
                </div>
                <div class="d-flex g-2">
                    <label for=""><?=lang_contact('news_hit')?></label>
                    <?=\App\Helpers\NumberHelper::format($item->hit_number, true)?>
                </div>
            </div>
            <div class="form-gp">
                <div class="d-flex g-2">
                    <label for=""><?=lang_contact('news_category')?></label>
                    <?=$item->category_name?>
                </div>
                <div class="d-flex g-2">
                    <label for=""><?=lang_contact('news_date')?></label>
                    <?=\App\Helpers\DateHelper::toTimeString($item->created_at,'yyyy-MM-dd')?>
                </div>
            </div>
        </div>

        <div class="border-light-box order-form">
            <div class="sub_title d-flex"><?=lang_common('question')?></div>
            <div class="form-gp">                
                <div class="d-flex g-1">
                    <?php echo htmlspecialchars_decode($item->content)?>
                </div>
            </div>
        </div>

        <div class="border-light-box order-form">
            <div class="sub_title d-flex"><?=lang_common('answer')?></div>
            <div class="form-gp">                
                <div class="d-flex g-1">
                    <?php echo htmlspecialchars_decode($item->answer_content)?>
                </div>
            </div>
        </div>

        </div>

        <div class="order-btn-box btn-box">
        <a href="<?=route_guest('inquiry')?>" class="btn font-xsm btn-blue float-r ml-1"><?=lang_contact('news_list')?></a>
        <a href="<?=route_guest('inquiry.update', $item->id)?>" class="btn font-xsm btn-blue float-r"><?=lang_common('update')?></a>
        </div>
    </div>

    <?php } else { ?>

        <?php if(AuthHelpers::checkLoginGuest()) {
            $memberCode = AuthHelpers::getLoginInfoGuest()->member_code;
            $itemMemberCode = $item->member_code;

            if ( $memberCode == $itemMemberCode) {
        ?>

    <div class="border-light-box">
        <div class="border-light-box order-form">
            <div class="sub_title d-flex">문의상품정보</div>
            <table class="prd-linelist">
                <thead>
                    <tr>
                    <td class="image">Image</td>
                    <td class="info1">Mfr.Part#</td>
                    <td class="info2">Manufacturer</td>
                    <td class="desc">Description</td>
                    <td class="info3">MOQ/MPQ/PKG</td>
                    <td class="info4">Priceing</td>
                    </tr>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td class="image">
                            <a href="<?=route_guest('sale.detail', $productinfo->product_code)?>">
                            <?php if(isset($productinfo->image_dir) && $productinfo->image_dir != ''): ?>
                                <?php if(isset($productinfo->api_flg) && $productinfo->api_flg == '1'): ?>
                                    <img src="<?=$productinfo->image_dir?>"/>
                                <?php else : ?>
                                    <img src="<?=asset_public($productinfo->image_dir)?>"/>
                                <?php endif; ?>
                            <?php else : ?>
                                <img src="<?=asset_public('images/no_image_available.jpg')?>"/>
                            <?php endif; ?>
                            </a>
                        </td>
                        <td data-label="Mfr.Part#" class="info1">
                            <a href="<?=route_guest('sale.detail', $productinfo->product_code)?>">
                            <?=$productinfo->part_number?>
                            </a>
                            <input id="name" type="hidden" class="form-control" name="part_number" value="<?=$productinfo->part_number?>" placeholder="<?=lang_cart('part_number')?>" aria-describedby="part_number"/>
                        </td>
                        <td data-label="Manufacturer" class="info2"><?=$productinfo->name?></td>
                        <?php
                            $brief_description = $productinfo->brief_description;
                            $prd_description = explode('|^|', $brief_description);
                        ?>
                        <td data-label="Description" class="desc"><?=$prd_description[0]?>, <?=$prd_description[1]?></td>
                        <td data-label="MOQ/MPQ/PKG" class="info3">                                    
                            <ul>
                                <li>MOQ : <?=\App\Helpers\NumberHelper::format($productinfo->moq, true)?></li>
                                <li>MPQ : <?=\App\Helpers\NumberHelper::format($productinfo->mpq, true)?></li>
                                <li>PKG : <?=$productinfo->packing_name?>(<?=$productinfo->packing_code?>)</li>
                            </ul>  
                        </td>
                        <td data-label="Priceing" class="info4">
                            <ul>
                                <?php 
                                if($productinfo->unit_mini_quantity1 > 0) {
                                echo '<li style="text-align: right;">'.\App\Helpers\NumberHelper::format($productinfo->unit_mini_quantity1, true).'개 ~';
                                echo ' '.\App\Helpers\NumberHelper::format($productinfo->selling_price1, true).''.lang_sale('price_unit').'</li>';
                                }
                                if($productinfo->unit_mini_quantity2 > 0) {
                                echo '<li style="text-align: right;">'.\App\Helpers\NumberHelper::format($productinfo->unit_mini_quantity2, true).'개 ~';
                                echo ' '.\App\Helpers\NumberHelper::format($productinfo->selling_price2, true).''.lang_sale('price_unit').'</li>';
                                }
                                if($productinfo->unit_mini_quantity3 > 0) {
                                echo '<li style="text-align: right;">'.\App\Helpers\NumberHelper::format($productinfo->unit_mini_quantity3, true).'개 ~';
                                echo ' '.\App\Helpers\NumberHelper::format($productinfo->selling_price3, true).''.lang_sale('price_unit').'</li>';
                                }

                                if($productinfo->unit_mini_quantity4 > 0) {
                                echo '<li style="text-align: right;">'.\App\Helpers\NumberHelper::format($productinfo->unit_mini_quantity4, true).'개 ~';
                                echo ' '.\App\Helpers\NumberHelper::format($productinfo->selling_price4, true).''.lang_sale('price_unit').'</li>';
                                }
                                if($productinfo->unit_mini_quantity5 > 0) {
                                echo '<li style="text-align: right;">'.\App\Helpers\NumberHelper::format($productinfo->unit_mini_quantity5, true).'개 ~';
                                echo ' '.\App\Helpers\NumberHelper::format($productinfo->selling_price5, true).''.lang_sale('price_unit').'</li>';
                                }
                                if($productinfo->unit_mini_quantity6 > 0) {
                                echo '<li style="text-align: right;">'.\App\Helpers\NumberHelper::format($productinfo->unit_mini_quantity6, true).'개 ~';
                                echo ' '.\App\Helpers\NumberHelper::format($productinfo->selling_price6, true).''.lang_sale('price_unit').'</li>';
                                }
                                ?>
                            </ul> 
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>

        <div class="border-light-box order-form">
            <div class="sub_title d-flex"><?=lang_inquiry('title')?></div>
            <div class="sub_title"><?=$item->title?></div>
            <div class="form-gp">
                <div class="d-flex g-2">
                    <label for=""><?=lang_contact('news_id')?></label>
                    <?=$item->user_name?>
                </div>
                <div class="d-flex g-2">
                    <label for=""><?=lang_contact('news_hit')?></label>
                    <?=\App\Helpers\NumberHelper::format($item->hit_number, true)?>
                </div>
            </div>
            <div class="form-gp">
                <div class="d-flex g-2">
                    <label for=""><?=lang_contact('news_category')?></label>
                    <?=$item->category_name?>
                </div>
                <div class="d-flex g-2">
                    <label for=""><?=lang_contact('news_date')?></label>
                    <?=\App\Helpers\DateHelper::toTimeString($item->created_at,'yyyy-MM-dd')?>
                </div>
            </div>
        </div>

        <div class="border-light-box order-form">
            <div class="sub_title d-flex"><?=lang_common('question')?></div>
            <div class="form-gp">                
                <div class="d-flex g-1">
                    <?php echo htmlspecialchars_decode($item->content)?>
                </div>
            </div>
        </div>

        <div class="border-light-box order-form">
            <div class="sub_title d-flex"><?=lang_common('answer')?></div>
            <div class="form-gp">                
                <div class="d-flex g-1">
                    <?php echo htmlspecialchars_decode($item->answer_content)?>
                </div>
            </div>
        </div>

        </div>

        <div class="order-btn-box btn-box">
        <a href="<?=route_guest('inquiry')?>" class="btn font-xsm btn-blue float-r ml-1"><?=lang_contact('news_list')?></a>
        <a href="<?=route_guest('inquiry.update', $item->id)?>" class="btn font-xsm btn-blue float-r"><?=lang_common('update')?></a>
        </div>
    </div>

        <?php } else { ?>
                <div class="border-light-box order-form">

                <script src="<?=asset_guest_js('sweetalert.min.js')?>"></script>

                <script>
                    swal({
                    title: "접근경로 오류",
                    text: "접근경로가 바르지 않습니다. 정보를 확인 하시기 바랍니다.",
                    icon: "warning",
                    buttons: "확인"
                    }).then(function() {
                        window.location = "<?=route_guest('inquiry')?>";
                    });
                </script>

            </div>
        <?php 
            }
        ?>

        <?php 
            }
        } ?>

    </div>
</section>  
<!---------------------------------------------------------------------------------------------->
<script>
	$(function () {        
        $('.myMenu ul li').on('mouseenter mouseleave', function () {
            $(this).children('ul').stop(true, false, true).slideToggle(10);
        });
    });

    $(document).ready(function() {
        $('.category-toggle').click(function() {
            $('.category-box').slideToggle(300); // 슬라이드 애니메이션 효과로 펼치고 접기
            $(this).toggleClass('on');
        });
    });

    /* prd category */    
    $(".prd_cate_item a").click(function(){
        $(".prd_cate_item a").removeClass("active");
        //this는 함수를 실행하게 만든 그 클릭한 요소다!
        $(this).addClass("active");//그 요소에게 효과주고        
    });

    /* 상품 정렬 */
    $(".align-item a").click(function(){
        $(".align-item a").removeClass("active");
        //this는 함수를 실행하게 만든 그 클릭한 요소다!
        $(this).addClass("active");//그 요소에게 효과주고        
    });
    
</script>
<!---------------------------------------------------------------------------------------------->
<?= $this->endSection() ?>
