<!doctype html>
<html lang="kr">
   <head>
    <!-- Required meta tags -->
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- SEO 설정 -->
    <meta name="Robots" content="index,follow" />
    <meta name="title" content="칩다이렉트" />
    <meta name="author" content="전자부품 전문 쇼핑몰 칩다이렉트" />
    <meta name="description" content="전자부품 쇼핑몰,전자부품 판매, 토탈 턴키 서비스, 공구, 학교 연구소 후불구매" />
    <meta name="keywords" content="전자부품,전자부품쇼핑몰,엘레파츠,디지키,마우저,디바이스마트,아이씨뱅큐,올파츠,ic114,턴키,저항,인덕터,커넥터,ic,아이씨,반도체,비드,인덕터,led,전자부품구매" />

    <?php
    /*
    echo $_SERVER['HTTP_HOST'];
    echo "<br>";
    echo $_SERVER['REQUEST_URI'];
    echo "<br>";
    echo 'http://' . $http_host . $request_uri;
    echo "<br>";
    var_dump($requrl_arr[2]);
    echo $item->part_number;
    echo "<br>";
    echo $item->name;
    exit;
    */
    $reqhost = $_SERVER['HTTP_HOST'];
    $requrl = $_SERVER['REQUEST_URI'];
    $requrl_arr = explode('/', $requrl);

    if ($requrl_arr[2] == "detail") {
        echo "<meta property='og:url' content='https://".$reqhost.$requrl."' />\n";
        echo "<meta property='og:site_name' content='칩다이렉트' />\n";
        echo "<meta property='og:title' content='".$item->part_number."' />\n";
        echo "<meta property='og:description' content='".$item->brief_description."' />\n";
        echo "<meta property='fb:app_id' content='".$item->product_code."' />\n";
        echo "<meta property='og:type' content='product' />\n";
        echo "<meta property='product:price:amount' content='".$item->selling_price1."' />\n";
        echo "<meta property='product:brand' content='".$item->name."' />\n";
        echo "<meta property='product:price:currency' content='KRW' />\n";
        echo "<meta property='product:product_link' content='https://".$reqhost.$requrl."' />\n";
        echo "<meta property='product:category' content='".$item->part_category_name." &gt; ".$item->part_category2_name."' />\n";


        if(isset($item->image_dir) && $item->image_dir != '') {
            if(isset($item->image_dir) && $item->image_dir != '' && $item->image_dir != 'Not') {
                if ($image_dir_is == "http") {
                    echo "<meta property='og:image' content='".$item->image_dir."'  />\n";
                    echo "<link rel='image_src' href='".$item->image_dir."' />\n";
                    echo "<meta property='og:image:width' content='300'  />\n";
                    echo "<meta property='og:image:height' content='300'  />\n";
                } else {
                    echo "<meta property='og:image' content='".asset_public($item->image_dir)."'  />\n";
                    echo "<link rel='image_src' href='".asset_public($item->image_dir)."' />\n";
                    echo "<meta property='og:image:width' content='300'  />\n";
                    echo "<meta property='og:image:height' content='300'  />\n";

                }
            } else {
                if ($item->api_code == "LC" && $item->product_api_id) {
                    echo "<meta property='og:image' content='".$item->image_dir."'  />\n";
                    echo "<link rel='image_src' href='".$item->image_dir."' />\n";
                    echo "<meta property='og:image:width' content='300'  />\n";
                    echo "<meta property='og:image:height' content='300'  />\n";

                }
            }
        }

    } else {
        echo "<meta property='og:type' content='website' />\n";
        echo "<meta property='og:site_name' content='칩다이렉트' />\n";
        echo "<meta property='og:title' content='전자부품 전문 쇼핑몰 칩다이렉트' />\n";
        echo "<meta property='og:description' content='전자부품 쇼핑몰,전자부품 판매, 토탈 턴키 서비스, 공구, 학교 연구소 후불구매' />\n";
        echo "<meta property='og:image' content='https://chipdirect.co.kr/images/top_logo.png' />\n";
        echo "<meta property='og:url' content='https://chipdirect.co.kr' />\n";
    }

    ?>


      <title>CHIPDIRECT :: 전자부품 전문몰 칩다이렉트</title>
      <!-- mormalize css 초기화 -->
      <link rel="stylesheet" href="<?=asset_guest_css('bootstrap.min.css')?>"/>
      <link rel="stylesheet" href="<?=asset_guest_css('normalize.css')?>"/>
      <link href="<?=asset_guest_css('common.css')?>" rel="stylesheet"/>
      <link href="<?=asset_guest_css('style.css')?>" rel="stylesheet"/>

      <!-- jquery 최신버전 -->
      <script  src="<?=asset_guest_js('jquery-latest.min.js')?>"></script>
      <!-- google-icons -->
      <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:opsz,wght,FILL,GRAD@20..48,100..700,0..1,-50..200" />

      <!-- Swiper CDN -->
      <link rel="stylesheet" href="<?=asset_guest_css('swiper-bundle.min.css')?>" />
    <!-- 네이버 공통 유입 스크립트 -->
    <script type="text/javascript" src="https://wcs.naver.net/wcslog.js"></script>  
    <script type="text/javascript"> 
        if(!wcs_add) var wcs_add = {};
        wcs_add["wa"] = "s_2cb93919468b";
        wcs.inflow("chipdirect.co.kr");
    </script>
   </head>

   <body id="pageTop">
    <!--#siteSubHead-->
    <?= view_cell('\App\Controllers\Guest\Layout\SubHeaderController::index') ?>
    <!--#siteHeader-->
    <?= view_cell('\App\Controllers\Guest\Layout\HeaderController::index') ?>

    <!--#Breadcrumb-->
    <?= $this->renderSection('body.breadcrumb') ?>

    <!--#siteMain-->
<!--    <div class="content">-->
        <?= $this->renderSection('content') ?>
<!--    </div>-->
    <?= view_cell('\App\Controllers\Guest\Layout\FooterController::index') ?>

    <!--Body Js-->
    <!-- Optional JavaScript -->
    <script src="<?=asset_guest_js('modal.js')?>"></script>
    <!-- Validation JS -->
    <script src="<?=asset_js('jquery.validate.js')?>"></script>
    <script src="<?=asset_js('additional-methods.min.js')?>"></script>
    <script src="<?=asset_js('jquery.validator.addMethod.js')?>"></script>
    <?php if(isset($validation)): ?>
        <script>
            let validation = $("#form").validate({
                    'errorClass' : 'is-invalid',
                    'errorElement' : 'span',
                    'errorElementClass' : 'error invalid-feedback',
                <?=$validation['rules']?>,
            <?=$validation['messages']?>
            });

        </script>
    <?php else: ?>
        <script>
            let validation = null;
        </script>
    <?php endif?>
    <script type="text/javascript">
        $(document).ready(function () {
            var stickyOffset = $('.sticky').offset().top;

            $(window).scroll(function(){
                var sticky = $('.sticky'),
                    scroll = $(window).scrollTop();

                if (scroll >= stickyOffset) sticky.addClass('fixed');
                else sticky.removeClass('fixed');
            });

            // set min height for main content
            var siteHeader = $('#siteHeader').height(),
                siteSubHead = $('#siteSubHead').height(),
                siteFooter = $('#siteFooter').height(),
                siteViewport = $(window).height();
            $('#siteMain').css('min-height', siteViewport - siteFooter - siteHeader - siteSubHead);
        })
    </script>
    
    <!-- Google tag (gtag.js) -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-ZL9NPN2FBP"></script>
    <script>
        window.dataLayer = window.dataLayer || [];
        function gtag(){dataLayer.push(arguments);}
        gtag('js', new Date());

        gtag('config', 'G-ZL9NPN2FBP');
    </script>

    <?= $this->renderSection('body.js') ?>

    <!-- Input hide -->
    <input type="hidden" name="is_login" value="<?=\App\Helpers\AuthHelpers::checkLoginGuest() ? 1 : 0?>"/>

    <!-- Include Model -->
    <?=$this->include('guest/common/__loading_form')?>

    <!-- Modal -->
    <?=$this->include('guest/common/__popup_success_modal')?>
    <?=$this->include('guest/common/__popup_danger_modal')?>

    <!-- Data Validation -->
    <?=$this->include('common/validations/value_data')?>

    <script type="text/javascript">
        wcs_do();
    </script>
</body>
</html>