<?php
use App\Helpers\AuthHelpers;
?>

<section id="siteSubHead" class="site-subhead">
<?php 
    //엣지 URL버그 교정
    $hostname=$_SERVER["HTTP_HOST"];
    if ($hostname == "www.chipdirect.co.kr") {
        Header('Location:https://chipdirect.co.kr');
        exit;
    }
?>
<header  id="header">

   <section class="header_bn">
      <div class="content_wrap">
         <ul class="img_bn">
            <?php if ($bannertop01) { ?>
               <a href="<?=$bannertop01->goto_URL?>"><li><img src="<?=asset_public($bannertop01->image_dir)?>" alt="<?=$bannertop01->title?>"></li></a>
            <?php } else { ?>
               <a href="#"><li><img src="<?=asset_public("images/top_bn1.png")?>"></li></a>
            <?php }
            if ($bannertop02) { ?>
               <a href="<?=$bannertop02->goto_URL?>"><li><img src="<?=asset_public($bannertop02->image_dir)?>" alt="<?=$bannertop02->title?>"></li></a>
            <?php } else { ?>
               <a href="#"><li><img src="<?=asset_public("images/top_bn2.png")?>"></li></a>
            <?php }
            if ($bannertop03) { ?>
               <a href="<?=$bannertop03->goto_URL?>"><li><img src="<?=asset_public($bannertop03->image_dir)?>" alt="<?=$bannertop03->title?>"></li></a>
            <?php } else { ?>
               <a href="#"><li><img src="<?=asset_public("images/top_bn3.png")?>"></li></a>
            <?php } ?>
         </ul>

         <ul class="txt_bn">
            <?php if ($bannertop01) { ?>
            <li><a href="<?=$bannertop01->goto_URL?>"><?=$bannertop01->title?></a></li>
            <?php }
               if ($bannertop02) { ?>
            <li><a href="<?=$bannertop02->goto_URL?>"><?=$bannertop02->title?></a></li>
            <?php }
               if ($bannertop03) { ?>
            <li><a href="<?=$bannertop03->goto_URL?>"><?=$bannertop03->title?></a></li>
            <?php } ?>
         </ul>
      </div>
   </section>

   <section class="top_header">
      <div class="content_wrap">
         <div class="d-flex">
         <button class="btn toggle-side-bar-btn bg-none mr-1" data-ico-now-animating="N">        
            <span class="material-symbols-outlined">menu</span>
         </button>
         <a href="<?=route_guest('home')?>" class="top_logo"><img src="<?=asset_public('images/top_logo.png')?>" alt=""></a>
         <form action="<?=route_guest('sale.index')?>" method="get" onsubmit="showLoadingMessage()">  
         </div>

         <div class="top_search">
               <input class="input" type="text" name="keyword" minlength="2" maxlength="60" placeholder="Search..." value="<?=$keyword?>" required>
               <button class="btn btn-search" type="submit" alt="검색"></button>
         </div>
         </form>

         <ul class="h_menu">
            <li class="h-m-01">
            <a href="<?=route_guest('cart')?>" title="장바구니">
               <i><span class="badge"><?=$cartCount?></span></i>
               <span>장바구니</span>
               </a>
            </li>
            <li class="h-m-02">
               <a href="<?=route_guest('estimate.create')?>" title="견적문의">
               <i><span class="badge"><?=$estimateCount?></span></i>
               <span>견적문의</span>
               </a>
            </li>
            <li class="h-m-03">
               <a href="<?=route_guest('orderinfo')?>" title="마이페이지">
               <i></i>
               <span>마이페이지</span>
               </a>
            </li>
            <?php if(AuthHelpers::checkLoginGuest()):?>
            <li class="h-m-04">
               <a href="<?=route_guest('my.info_edit')?>" title="정보수정">
               <i></i>
               <span>정보수정</span>
               </a>
            </li>
            <li class="h-m-06">
               <a href="<?=route_guest('logout')?>" title="로그아웃">
               <i></i>
               <span>로그아웃</span>
               </a>
            </li>
            <?php else: ?>
            <li class="h-m-04">
               <a href="<?=route_guest('register')?>" title="회원가입">
               <i></i>
               <span>회원가입</span>
               </a>
            </li>
            <li class="h-m-05">
               <a href="<?=route_guest('login')?>" title="로그인">
               <i></i>
               <span>로그인</span>
               </a>
            </li>
            <?php endif; ?>
         </ul>
      </div>
   </section>

   <div id="loading-overlay" class="loading-overlay">
      <div id="loading-message" class="loading-message">
        <div class="spinner"></div>
        <p>재고정보를 검색하고 있습니다.</p>
      </div>
    </div>

    <script>
        function showLoadingMessage() {
            document.getElementById('loading-overlay').style.display = 'block';
            document.getElementById('recaptcha-submit').disabled = true;
        }
    </script>

   <section class="m_searchWrap">
   <form action="<?=route_guest('sale.index')?>" method="get">  
      <div class="top_search">
      <input class="input" type="text" name="keyword" minlength="2" maxlength="60" placeholder="Search..." value="<?=$keyword?>" required>
      <button class="btn btn-search" type="submit" alt="검색"></button>
      </div>
   </form>
   </section>

</section>