<?= $this->extend('guest/layouts/master') ?>

<?= $this->section('head.title') ?>
    <?=lang_manufacturer('title')?>
<?= $this->endSection() ?>

<?= $this->section('body.breadcrumb')?>

<?=$this->endSection()?>

<?= $this->section('content') ?>
    <!--#siteMain-->
    <section id="siteMain" class="site-main">

    <div class="container">
            <!--h2 class="form-title"><?=lang_manufacturer('title')?></h2-->

    <div class="sub03Wrap">
        <div class="wrap">
            <div class="subWrap01Top">
                <div class="sub_category">
                    <div class="sub_categoryName">
                        <p>HOME > <?=lang_manufacturer('title')?>
                    </div>
                    <div class="sub_categoryBtn">
                        <p>서브메뉴 접기 </p>
                        <span><img src="<?=asset_public('images/upbtn.png')?>" alt="접기"></span>
                    </div>
                </div>
                <div class="sub_categoryMenu on">
                    <ul>
                        <li><a href="<?=route_guest('one2one')?>">1:1 상담</a></li>
                        <li><a href="<?=route_guest('inquiry')?>">상품문의</a></li>
                        <li><a href="<?=route_guest('estimate')?>">견적문의</a></li>
                        <li><a href="<?=route_guest('deferredpay')?>">후불문의</a></li>
                        <li><a href="<?=route_guest('orderinfo')?>">주문내역</a></li>
                        <li><a href="<?=route_guest('review')?>">상품후기</a></li>
                        <li><a href="<?=route_guest('refundinfo')?>">반품문의</a></li>
                        <li class="on"><a href="<?=route_guest('news')?>">공지사항</a></li>
                    </ul>
                </div>
            </div>

            <div class="sub03WrapT ">
                <div class="sub03WrapTList">

                </div>
                <div class="inquiryBtn">
                    <div class="news-action">
                        <div class="form-search">
                            <form method="get" action="<?=route_guest('manufacturer')?>">
                                <input class="form-control" placeholder="Name of manufacturer" name="name" value="<?=$name?>">
                                <button type="submit" class="btn btn-search"><i class="fas fa-search"></i></button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

                <div class="manufacturerMenu">
                    <ul>
                        <li><a href="<?=route_guest('one2one')?>">1:1 상담</a></li>
                        <li><a href="<?=route_guest('inquiry')?>">상품문의</a></li>
                        <li><a href="<?=route_guest('estimate')?>">견적문의</a></li>
                        <li><a href="<?=route_guest('deferredpay')?>">후불문의</a></li>
                        <li><a href="<?=route_guest('orderinfo')?>">주문내역</a></li>
                        <li><a href="<?=route_guest('review')?>">상품후기</a></li>
                        <li><a href="<?=route_guest('refundinfo')?>">반품문의</a></li>
                        <li class="on"><a href="<?=route_guest('news')?>">공지사항</a></li>
                    </ul>
                </div>

                <?php foreach ($lists as $key => $item): ?>
                    <div class="sub03Tablecont">
                    <div class="sub03Tablecont_line">
                        <div class="sub03Tablecont01 sub03TablecontSub"><?=show_no_row($key+1, $perPage, $currentPage)?></div>
                        <div class="sub03Tablecont02 sub03TablecontSub"><?=$item->code?></div>
                        <div class="sub03Tablecont03 sub03TablecontSub"><a href="<?=route_guest('manufacturer.detail', $item->id)?>"><?=$item->name?></a></div>
                        <div class="sub03Tablecont04 sub03TablecontSub"><?=$item->manufacturer_logo_dir?></div>
                    </div>
                    </div>

                <?php endforeach; ?>
                <?php if(count($lists) == 0): ?>
                    <div class="sub03Tablecont">
                        <div><?=lang_common('no_data')?></div>
                    </div>
                <?php endif;?>
            </div>
        </div>

            <div class="row">
                <div class="col-12">
                    <?= $pager->links() ?>
                </div>
            </div>
            
        </div>
    </section>
    <!--/#siteMain-->
<?= $this->endSection() ?>
