<?= $this->extend('guest/layouts/master') ?>

<?= $this->section('head.title') ?>
    <?=lang_quote_history('title')?>
<?= $this->endSection() ?>

<?= $this->section('content') ?>
<!--#siteMain-->
<section id="siteMain" class="site-main">
    <!--#Breadcrumb-->
    <?=$breadcrumb->render('guest.my_page.quote_history')?>

    <div class="container">
        <div class="row">
            <div class="col-12">
                <?= $pager->links() ?>
            </div>
        </div>
        <ul class="quote-list">
            <li class="title">
                <div class="quote_no"><?=lang_quote_history('no')?></div>
                <div class="quote_history_no"><?=lang_quote_history('quote_no')?></div>
                <div class="quote_history_date"><?=lang_quote_history('date')?></div>
                <div class="quote_history_amount"><?=lang_quote_history('amount')?></div>
                <div class="quote_detail"><?=lang_common('detail')?></div>
            </li>
            <?php foreach ($lists as $key => $item): ?>
                <li class="sale">
                    <div class="quote_no">
                        <?=show_no_row($key+1, $perPage, $currentPage)?>
                    </div>
                    <div class="quote_history_no">
                        <?=$item->quote_no?>
                    </div>
                    <div class="quote_history_date">
                        <?=\App\Helpers\DateHelper::toTimeString($item->quote_date,'yyyy-MM-DD')?>
                    </div>
                    <div class="quote_history_amount">
                        <?=\App\Helpers\NumberHelper::format($item->total_amount, true)?>
                    </div>
                    <div class="quote_detail">
                        <a class="btn btn-sm btn-outline-secondary btn-add-cart w-100"
                           title="<?=lang_common('detail')?>" href="<?=route_guest('my.quotation_history.detail', $item->id)?>">
                            <?=lang_common('detail')?>
                        </a>
                    </div>
                </li>
            <?php endforeach; ?>
            <?php if(count($lists) == 0): ?>
                <li class="sale">
                    <div><?=lang_common('no_data')?></div>
                </li>
            <?php endif;?>
        </ul>

        <div class="row">
            <div class="col-12">
                <?= $pager->links() ?>
            </div>
        </div>
    </div>
</section>
<?= $this->endSection() ?>
