<?= $this->extend('guest/layouts/master') ?>

<?= $this->section('head.title') ?>
    <?=$item->quote_no?>
<?= $this->endSection() ?>

<?= $this->section('body.breadcrumb') ?>

<?= $this->endSection() ?>

<?= $this->section('content') ?>
<!--#siteMain-->
<section id="siteMain" class="site-main">

    <div class="container">
        <h2 class="form-title"><?=lang_sale('list_title')?></h2>
        <ul class="cart-list">
            <li class="title">
                <div class="cart_compare">
                    <?=lang_common('no')?>
                </div>
                <div class="cart_part_number"><?=lang_cart('part_number')?></div>
                <div class="cart_manufacturer"><?=lang_cart('manufacturer')?></div>
                <div class="cart_quantity"><?=lang_cart('qty')?></div>
                <div class="cart_price"><?=lang_cart('price')?></div>
                <div class="cart_amount"><?=lang_cart('amount')?></div>
            </li>
            <?php foreach ($list as $key => $itemQuote): ?>
                <li class="cart" data-id="<?=$itemQuote->part_number?>">
                    <div class="cart_compare">
                        <?=$key + 1?>
                    </div>
                    <div class="cart_part_number">
                        <?=$itemQuote->part_number?>
                    </div>
                    <div class="cart_manufacturer">
                        <?=$itemQuote->name?>
                    </div>
                    <div class="cart_quantity">
                        <?=\App\Helpers\NumberHelper::format($itemQuote->qty, true)?>
                    </div>
                    <div class="cart_price">
                        <?=\App\Helpers\NumberHelper::format($itemQuote->price, true)?>
                    </div>
                    <div class="cart_amount">
                        <?=\App\Helpers\NumberHelper::format($itemQuote->amount, true)?>
                    </div>
                </li>
            <?php endforeach; ?>
        </ul>
        <div class="total_item text-right">
            <div>
                <?=lang_cart('total_amount')?> :
                <span class="amount_item"><?=\App\Helpers\NumberHelper::format($item->amount, true)?></span>
            </div>
            <div>
                <?=lang_cart('vat')?> :
                <span class="amount_vat"><?=\App\Helpers\NumberHelper::format($item->total_vat, true)?></span>
            </div>
        </div>
        <div class="total text-right">
            <div>
                <?=lang_cart('total')?> :
                <span class="amount_total"><?=\App\Helpers\NumberHelper::format($item->total_amount, true)?></span>
            </div>
        </div>
        <div class="memo">
            <div class="form-group">
                <textarea class="form-control" name="memo_content" rows="5" placeholder="Memo"><?=$item->quote_memo?></textarea>
            </div>
        </div>
        <div class="cart-button text-center">
            <a class="btn btn-danger maxw-200 w-100" href="<?=route_guest('my.quotation_history')?>">
                <?=lang_quote_history('button_list')?>
            </a>
        </div>
    </div>
</section>

<?= $this->endSection() ?>
