<?php
use App\Helpers\AuthHelpers;
?>

<?= $this->extend('guest/layouts/master') ?>

<?= $this->section('head.title') ?>
    <?=$item->title?>
<?= $this->endSection() ?>

<?= $this->section('body.js') ?>

    <script type="text/javascript">
        function selectAll(selectAll)  {
        const checkboxes 
            = document.querySelectorAll('input[id="pcheckbox"]');
        checkboxes.forEach((checkbox) => {
            checkbox.checked = selectAll.checked
        })
        }
	</script>
<?= $this->endSection() ?>

<?= $this->section('body.breadcrumb')?>

<?=$this->endSection()?>

<?= $this->section('content') ?>
<!--#siteMain-->

<!-- product details top info s -->
<section class="sub_wrap">
    <div class="content_wrap">
<!------------------------------------------------------------------------------------------------------------------->

        <nav class="breadcrumb" style='background-color: #ffffff;'>
            <ul>
            <li><a href='<?=route_guest('home')?>'><img src='<?=asset_public('images/ico-home.png')?>' alt=''></a></li>
            <li><a href="#">마이페이지</a></li>
                <li><a href="#"><?=lang_orderinfo('title')?></a></li>                
            </ul>            
        </nav>

        <div class="prd-category mt-2">            
            <select name="" id="" class="prd-cate-mo">
                <option value=""><a href="<?=route_guest('one2one')?>">1:1 상담</a></option>
                <option value=""><a href="<?=route_guest('inquiry')?>">상품문의</a></option>
                <option value=""><a href="<?=route_guest('estimate')?>">견적문의</a></option>
                <!--option value=""><a href="<?=route_guest('deferredpay')?>">후불문의</a></option-->
                <option value=""><a href="<?=route_guest('orderinfo')?>">주문내역</a></option>
                <!--option value=""><a href="<?=route_guest('review')?>">상품후기</a></option-->
                <option value=""><a href="<?=route_guest('refundinfo')?>">반품문의</a></option>
                <!--option value=""><a href="<?=route_guest('news')?>">공지사항</a></option-->
            </select>

            <div class="prd-cate-pc">
                <div class="category-toggle">                
                마이페이지
                </div>
                <div class="category-box">
                    <ul>
                        <li class="prd_cate_item"><a href="<?=route_guest('one2one')?>">1:1 상담</a></li>
                        <li class="prd_cate_item"><a href="<?=route_guest('inquiry')?>">상품문의</a></li>
                        <li class="prd_cate_item"><a href="<?=route_guest('estimate')?>">견적문의</a></li>
                        <!--li class="prd_cate_item"><a href="<?=route_guest('deferredpay')?>">후불문의</a></li-->
                        <li class="prd_cate_item"><a href="<?=route_guest('orderinfo')?>" class="active">주문내역</a></li>
                        <!--li class="prd_cate_item"><a href="<?=route_guest('review')?>">상품후기</a></li-->
                        <li class="prd_cate_item"><a href="<?=route_guest('refundinfo')?>">반품문의</a></li>
                        <!--li class="prd_cate_item"><a href="<?=route_guest('news')?>">공지사항</a></li-->
                    </ul>
                </div>
            </div>
        </div>

<!------------------------------------------------------------------------------------------------------------------->


    <?php if ($orderInfo->member_code != AuthHelpers::getLoginInfoGuest()->member_code ) {?>
    <script src="<?=asset_guest_js('sweetalert.min.js')?>"></script>
    <script>
        $(document).ready(function () {
    
            swal({
                title: "정보오류",
                text: "회원정보가 없거나 일치하지 않습니다.",
                icon: "warning",
                button: "확인",
            })
            .then(function(){
                location.href = "/orderinfo";
            });
    
        });
    </script>
    <?php } else {?>

    <script>
        function info_chk1(frm) {
        frm.action='<?=route_guest('orderinfo.torefund')?>';
        frm.submit();
        return true;
        }
        function info_chk2(frm) {
        frm.action='<?=route_guest('orderinfo.modify')?>';
        frm.submit();
        return true;
        }
        function info_chk3(frm) {
        frm.action='#';
        frm.submit();
        return true;
        }
    </script>

    <form id="form-cart" name="user_form" method="post">
    <div class="order_ListTdWrap">
                <?php if (!$lists) :?>

                <div class="border-light-box order-form">
                    <div class="sub_title d-flex">주문내역에 등록된 상품이 없습니다.</div>
                    <div class="form-gp">
                        <div class="d-flex g-1">
                        주문내역에 등록된 상품이 없습니다.
                        </div>                
                    </div>
                    <div class="form-gp">
                        <div class="d-flex g-1">
                            <label for=""> </label>
                        </div>                
                    </div>
                </div>

                <div class="order-btn-box btn-lg-box btn-box align-c mt-3 mb-1">
                    <a href="<?=route_guest('home')?>"><button class="btn btn-lg btn-blue w-20 ml-1">확인</button></a>
                </div>

                <?php else: ?>

        <!-- 주문 상품정보 s -->
        <div class="border-light-box">
            <div class="sub_title">주문 상품정보</div>
            <table class="table_style2 order_list">
                <thead>
                    <tr>
                    <?php if($orderInfo->order_status == 5 || $orderInfo->order_status == 6 || $orderInfo->order_status == 7) { ?>
                        <th><input type='checkbox' name='product' value='selectall'  onclick='selectAll(this)'/></th>
                    <?php } ?>
                        <th>제품사진</th>
                        <th>주문상품</th>
                        <th>단가</th>
                        <th>주문수량</th>
                        <th>주문상태</th>
                        <th>배송사(송장)</th>
                        <th>공급가액(VAT)</th>
                        <th>금액</th>
                        </tr>
                </thead>
                <tbody>

                <?php $i = 1; ?>

                <?php foreach($lists as $item){?>
                    <input type="hidden" name="order_id<?=$i?>" value="<?=$item->order_id?>"/>
                    <input type="hidden" name="order_code<?=$i?>" value="<?=$item->order_code?>"/>
                    <input type="hidden" name="member_code<?=$i?>" value="<?=$item->member_code?>"/>
                    <input type="hidden" name="item_code<?=$i?>" value="<?=$item->item_code?>"/>
                    <input type="hidden" name="category3_code<?=$i?>" value="<?=$item->category3_code?>"/>
                    <input type="hidden" name="part_number<?=$i?>" value="<?=$item->part_number?>"/>
                    <input type="hidden" name="manufacturer_name<?=$i?>" value="<?=$item->manufacturer_name?>"/>
                    <input type="hidden" name="price<?=$i?>" value="<?=$item->price?>"/>
                    <input type="hidden" name="qty<?=$i?>" value="<?=$item->qty?>"/>
                    <input type="hidden" name="supply_price<?=$i?>" value="<?=$item->supply_price?>"/>
                    <input type="hidden" name="vat<?=$i?>" value="<?=$item->vat?>"/>
                    <input type="hidden" name="amount<?=$i?>" value="<?=$item->amount?>"/>
                    <input type="hidden" name="stock_location<?=$i?>" value="<?=$item->stock_location?>"/>
                    <input type="hidden" name="delivery_code<?=$i?>" value="<?=$item->delivery_code?>"/>

                    <tr>
                        <?php if($orderInfo->order_status == 5 || $orderInfo->order_status == 6 || $orderInfo->order_status == 7) { ?>
                        <td><input id="pcheckbox"  type="checkbox" name="chk<?=$i?>" value="active"></td>
                        <?php } ?>
                        <td><p class="prd-img">
                        <?php if(isset($item->nowinfo['image_dir']) && $item->nowinfo['image_dir'] != ''): ?>
                            <?php if(isset($item->nowinfo['api_flg']) && $item->nowinfo['api_flg'] == '1'): ?>
                                <img src="<?=$item->nowinfo['image_dir']?>"/>
                            <?php else : ?>
                                <img src="<?=asset_public($item->nowinfo['image_dir'])?>"/>
                            <?php endif; ?>
                        <?php else : ?>
                            <img src="<?=asset_public('images/no_image_available.jpg')?>"/>
                        <?php endif; ?>
                        </p></td>
                        <td>
                            <p class="col-blue font-sm"><?php echo $item->manufacturer_name;?></p>
                            <p class="prd-subject"><?php echo $item->part_number;?></p>
                            <p><label class="badge_blue font-sm">
                                <?php foreach ($stocklocationcategorys as $stock_location): ?>
                                    <?php if($stock_location->location_id == $item->stock_location) echo $stock_location->location_info;?>
                                <?php endforeach; ?>
                            </label></p>
                            <p class="prd-cmt col-gray font-sm"><?=$item->nowinfo['product_code']?></p>
                            <p class="prd-option col-gray font-sm">
                                <?php
                                $brief_description = $item->nowinfo['brief_description'];
                                $prd_description = explode('|^|', $brief_description);

                                echo mb_strimwidth($prd_description[1],'0',30,'...','utf-8');
                                ?>
                            </p>
                        </td>


                        <td><?=number_format($item->price)?>원</td>
                        <td><?php echo $item->qty?></td>
                        <td>
                            <?php
                            foreach ($orderstatus as $order_status):
                                if($order_status->status_code == $item->order_status) {
                                echo $order_status->status_info;
                                }
                            endforeach; 
                            ?>
                        </td>
                        <td>
                            <?php
                            foreach ($shippingcompany as $shipping_company):
                                if($shipping_company->shipping_id == $item->ship_company) {
                                echo $shipping_company->shipping_name;
                                }
                            endforeach; 
                            ?>
                        <br>
                            <?php echo $item->invoice_num;?>
                        </td>
                        <td><?=number_format($item->supply_price)?>원 (<?=number_format($item->vat)?>원)</td>
                        <td><?=number_format($item->amount)?>원</td>
                    </tr>

                    <?php
                    $all_qty = $all_qty + $item->qty;
                    $all_amount_price = $all_amount_price + $item->supply_price;
                    $all_price_vat = $all_price_vat + $item->vat;
                    
                    $i++; 

                    }
                    $total_all_price = $all_amount_price + $all_price_vat;
                    ?>
                </tbody>
            </table>

<!-------------------------------------------------------------------------------------------------------------------->

            <dl class="order_list_mobile">
                <dt>                    
                    <?php
                    $i = 1; 
                    $deliverydays = 0;
                    foreach($lists as $item_mobile){
                    ?>
                    <div class="prd-img">
                        <?php if(isset($item_mobile->nowinfo['image_dir']) && $item_mobile->nowinfo['image_dir'] != ''): ?>
                            <?php if(isset($item_mobile->nowinfo['api_flg']) && $item_mobile->nowinfo['api_flg'] == '1'): ?>
                                <img src="<?=$item_mobile->nowinfo['image_dir']?>"/>
                            <?php else : ?>
                                <img src="<?=asset_public($item_mobile->nowinfo['image_dir'])?>"/>
                            <?php endif; ?>
                        <?php else : ?>
                            <img src="<?=asset_public('images/no_image_available.jpg')?>"/>
                        <?php endif; ?>
                    </div>
                    <div class="prd-info">
                        <p><label class="badge_blue font-sm">
                            <?php foreach ($stocklocationcategorys as $stock_location): ?>
                                <?php if($stock_location->location_id == $item_mobile->nowinfo['stock_location']) echo $stock_location->location_info;?>
                            <?php endforeach; ?>
                        </label></p>                     
                        <p class="col-blue font-sm"><?=$item_mobile->name;?></p>
                        <p class="prd-subject"><?=$item_mobile->part_number;?></p>
                        <p class="prd-cmt col-gray font-sm"><?=$item_mobile->nowinfo['product_code']?></p>
                        <p class="prd-option col-gray font-sm">
                                <?php
                                $brief_description = $item_mobile->nowinfo['brief_description'];
                                $prd_description = explode('|^|', $brief_description);
                                echo mb_strimwidth($prd_description[1],'0',30,'...','utf-8');
                                ?>
                        </p>
                        <p class="prd-subject">단가 : <?=number_format($item->price)?>원</p>
                        <p class="prd-subject">수량 : <?php echo $item->qty;?></p>
                    </div>
                    <?php } ?>
                </dt>
                <dd class="bg-light-gray border-b">
                    <ul>
                        <li>상품갯수</li> <li><?=$all_qty?>개</li>
                        <li>합계금액</li> <li><?=number_format($total_all_price)?>원 (VAT포함)</li>
                        <li>배송료</li> <li><?=number_format($orderInfo->delivery_fee)?>원</li>
                        <li>총 결제 금액</li> <li><?=number_format($orderInfo->amount_total)?>원</li>
                    </ul>
                </dd>
            </dl>

            <table class="table_style2 order_list_footer">
                <thead>
                    <tr>
                        <th>상품개수</th>
                        <th>합계금액</th>
                        <th>배송료</th>
                        <th>총 결제 금액</th>                        
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td><?=$all_qty?>개</td>
                        <td><?=number_format($total_all_price)?>원 (VAT포함)</td>
                        <td><?=number_format($orderInfo->delivery_fee)?>원</td>
                        <td><?=number_format($orderInfo->amount_total)?>원</td>                        
                    </tr>                    
                </tbody>
            </table>

        <?php endif; ?>

        <input type="hidden" name="firstitem_code" value="<?=$orderInfo->firstitem_code?>"/>
        <input type="hidden" name="firstitem_number" value="<?=$orderInfo->firstitem_number?>"/>
        <input type="hidden" name="firstitem_image" value="<?=$orderInfo->firstitem_image?>"/>
        <input type="hidden" name="item_counts" value="<?=$orderInfo->item_counts?>"/>
        <input type="hidden" name="supply_price" value="<?=$orderInfo->supply_price?>"/>
        <input type="hidden" name="vat" value="<?=$orderInfo->vat?>"/>
        <input type="hidden" name="amount_total" value="<?=$orderInfo->amount_total?>"/>
        <input type="hidden" name="delivery_fee" value="<?=$orderInfo->delivery_fee?>"/>
        <input type="hidden" name="change_flg" value="<?=$orderInfo->change_flg?>"/>
        <input type="hidden" name="refund_flg" value="<?=$orderInfo->refund_flg?>"/>
        <input type="hidden" name="payment_date" value="<?=$orderInfo->payment_date?>"/>

<!------------------------------------------------------------------------------------------------------------------->

        <?php
            $loginTime = time() + 604800;
            $refund_code = "RFD".date(time());
        ?>

        <input type="hidden" name="refund_code" value="<?=$refund_code?>"/>  
        <input type="hidden" name="order_status" value="<?=$orderInfo->order_status?>"/>  
        <input type="hidden" name="member_code" value="<?=$orderInfo->member_code?>"/>  

                <div class="border-light-box order-form">
                    <div class="form-gp">
                        <div class="d-flex g-2">
                            <label for="">진행상태</label>
                            <?php
                            foreach ($orderstatus as $order_status){ 
                                if($order_status->status_code == $orderInfo->order_status) { echo $order_status->status_info; }
                            }
                            ?>
                        </div>
                        <div class="d-flex g-2">
                            <label for="">발송예정일</label>
                            <?=$orderInfo->delivery_date?>
                        </div>
                        <input type="hidden" name="order_code" value="<?=$orderInfo->order_code?>"/>
                    </div>
                </div>

                <!-- 주문자 정보 s -->
                <div class="border-light-box order-form">
                    <div class="sub_title d-flex">주문자 정보</div>
                    <input type="hidden" name="info_id" value="<?=$orderInfo->info_id?>"/>
                    <input type="hidden" name="order_code" value="<?=$orderInfo->order_code?>"/>
                    <div class="form-gp">
                        <div class="d-flex g-2">
                            <label for="">주문자</label>
                            <?=$orderInfo->orderer_name?>
                            <input type="hidden" name="orderer_name" value="<?=$orderInfo->orderer_name?>"/>
                        </div>
                        <div class="d-flex g-2">
                            <label for="">이메일</label>
                            <?=$orderInfo->orderer_email?>
                            <input type="hidden" name="orderer_email" value="<?=$orderInfo->orderer_email?>"/>
                        </div>
                    </div>
                    <div class="form-gp">
                        <div class="d-flex g-1">
                            <label for="">주문자 휴대폰 <span class="col-red">*</span></label>
                            <?=$orderInfo->orderer_phone?>
                            <input type="hidden" name="orderer_phone" value="<?=$orderInfo->orderer_phone?>"/>
                        </div>                
                    </div>
                </div>
                <!-- 주문자 정보 e -->

                        <!-- 배송지 정보 s -->
                        <div class="border-light-box order-form">
                            <div class="sub_title d-flex">배송지 정보</div>

            <?php if ($orderInfo->order_status =="1" || $orderInfo->order_status =="2" || $orderInfo->order_status =="3" || $orderInfo->order_status =="14" ) {?>

                            <div class="form-gp">
                                <div class="d-flex g-2">
                                    <label for="">받는분 <span class="col-red">*</span></label>
                                    <input id="shipping_name" type="text" name="shipping_name"  value="<?=$orderInfo->shipping_name?>" aria-describedby="shipping_name" required/>
                                </div>                
                            </div>
                            <div class="form-gp">
                                <div class="d-flex g-2">
                                    <label for="">받는분 휴대폰 <span class="col-red">*</span></label>
                                    <input id="shipping_phone" type="text" name="shipping_phone" value="<?=$orderInfo->shipping_phone?>" aria-describedby="shipping_phone" required/>
                                </div>
                                <div class="d-flex g-2">
                                    <label for="">받는분 전화 <span class="col-red">*</span></label>
                                    <input id="delivery_phone" type="text" name="delivery_phone" value="<?=$orderInfo->delivery_phone?>" aria-describedby="delivery_phone"/>
                                </div>
                            </div>
                            <div class="form-gp">
                                <div class="d-flex g-1">
                                    <label for="">회사명</label>
                                    <input id="company_name" type="text" name="company_name" value="<?=$orderInfo->company_name?>" placeholder="회사(학교)명을 입력하세요.">
                                </div>
                            </div>
                            <div class="form-gp">
                                <div class="d-flex g-2">
                                    <label for="">우편번호</label>
                                    <div class="group-btn d-flex">
                                    <input id="shipping_zipocode" type="text" name="shipping_zipocode" value="<?=$orderInfo->shipping_zipocode?>" placeholder="우편번호">
                                    <input type="button" onclick="sample6_execDaumPostcode()" value="우편번호 찾기" class="btn btn-gray ml-1">
                                    </div>
                                </div>
                                <div class="d-flex g-2"> </div>
                            </div>
                            <div class="form-gp">                
                                <div class="d-flex g-2">
                                    <label for="">배송지</label>
                                    <input id="shipping_add1" type="text" name="shipping_add1" value="<?=$orderInfo->shipping_add1?>" placeholder="주소" required>
                                </div>
                            </div>
                            <div class="form-gp">                
                                <div class="d-flex g-1">
                                    <label for="">배송지</label>
                                    <input id="shipping_add2" type="text" name="shipping_add2" value="<?=$orderInfo->shipping_add2?>" placeholder="상세주소">
                                </div>
                            </div>
                            <div class="form-gp">                
                                <div class="d-flex g-1">
                                    <label for="">배송메시지 </label>
                                    <input id="shipping_message" type="text" name="shipping_message" value="<?=$orderInfo->shipping_message?>" placeholder="배송메시지를 입력하세요.">
                                </div>
                            </div>

            <?php } else { ?>


                
                            <div class="form-gp">
                                <div class="d-flex g-2">
                                    <label for="">받는분</label>
                                    <?=$orderInfo->shipping_name?>
                                    <input type="hidden" name="shipping_name" value="<?=$orderInfo->shipping_name?>"/>
                                </div>                
                            </div>
                            <div class="form-gp">
                                <div class="d-flex g-2">
                                    <label for="">받는분 휴대폰</label>
                                    <?=$orderInfo->shipping_phone?>
                                    <input type="hidden" name="shipping_phone" value="<?=$orderInfo->shipping_phone?>"/>
                                </div>
                                <div class="d-flex g-2">
                                    <label for="">받는분 전화</label>
                                    <?=$orderInfo->delivery_phone?>
                                    <input type="hidden" name="delivery_phone" value="<?=$orderInfo->delivery_phone?>"/>
                                </div>
                            </div>
                            <div class="form-gp">
                                <div class="d-flex g-1">
                                    <label for="">회사명</label>
                                    <?=$orderInfo->company_name?>
                                    <input type="hidden" name="company_name" value="<?=$orderInfo->company_name?>"/>
                                </div>
                            </div>
                            <div class="form-gp">                
                                <div class="d-flex g-2">
                                    <label for="">배송지</label>
                                    [<?=$orderInfo->shipping_zipocode?>] <?=$orderInfo->shipping_add1?> <?=$orderInfo->shipping_add2?>
                                    <input type="hidden" name="shipping_zipocode" value="<?=$orderInfo->shipping_zipocode?>"/>
                                    <input type="hidden" name="shipping_add1" value="<?=$orderInfo->shipping_add1?>"/>
                                    <input type="hidden" name="shipping_add2" value="<?=$orderInfo->shipping_add2?>"/>
                                </div>
                            </div>
                            <div class="form-gp">                
                                <div class="d-flex g-2">
                                    <label for="">배송메시지 </label>
                                    <?=$orderInfo->shipping_message?>
                                    <input type="hidden" name="shipping_message" value="<?=$orderInfo->shipping_message?>"/>
                                </div>
                            </div>
            <?php } ?>

                        </div>
                        <!-- 배송지 정보 e -->


                        <!-- 결제수단정보 s -->
                        <div class="border-light-box order-form">
                            <div class="sub_title d-flex">결제수단정보</div>
                            
                            <div class="form-gp">
                                <div class="d-flex g-2">
                                    <label for="">결제수단</label>
                                    <?php 
                                        if($orderInfo->payment_flg =="Card") {
                                            echo "이니페이 신용카드";
                                        } elseif ($orderInfo->payment_flg == "Directbank"){
                                            echo "이니페이 실시간이체";
                                        } elseif ($orderInfo->payment_flg == "vbank"){
                                            echo "이니페이 가상계좌";
                                        } elseif ($orderInfo->payment_flg == "onlynaverpay"){
                                            echo "이니페이 네이버페이";
                                        } elseif ($orderInfo->payment_flg == "onlykakaopay"){
                                            echo "이니페이 카카오페이";
                                        } elseif ($orderInfo->payment_flg == "NPay"){
                                            echo "네이버N페이";
                                        } elseif ($orderInfo->payment_flg == "Tran"){
                                            echo "무통장입금";
                                        }
                                    ?>
                                    <input type="hidden" name="payment_flg" value="<?=$orderInfo->payment_flg?>"/>
                                </div>
                                <div class="d-flex g-2">
                                    <?php
                                    if ($orderInfo->payMethod == "VBank") {
                                        echo "
                                            <label for=''>가상계좌</label> 은행:".$orderInfo->vactBankName." / 계좌번호:".$orderInfo->VACT_Num."/ 마감일:".$orderInfo->VACT_Date."
                                            <input type='hidden' name='vactBankName' value='".$orderInfo->vactBankName."'/>
                                            <input type='hidden' name='VACT_Num' value='".$orderInfo->VACT_Num."'/>
                                            <input type='hidden' name='VACT_Date' value='".$orderInfo->VACT_Date."'/>
                                        ";
                                    } else if ($orderInfo->payMethod == "VCard") {
                                        echo "
                                            <label for=''>승인번호</label>".$orderInfo->applNum."
                                            <input type='hidden' name='applNum' value='".$orderInfo->applNum."'/>
                                        ";
                                    }else if ($orderInfo->payMethod == "Card") {
                                        echo "
                                            <label for=''>승인번호</label>".$orderInfo->applNum." (".$orderInfo->P_FN_NM.")
                                            <input type='hidden' name='applNum' value='".$orderInfo->applNum."'/>
                                            <input type='hidden' name='P_FN_NM' value='".$orderInfo->P_FN_NM."'/>
                                        ";
                                    }
                                    ?>
                                </div>
                            </div>

                        </div>
                        <!-- 결제수단정보 e -->
        </div>

                <div class="order-btn-box btn-box">
                    <?php if ($orderInfo->tid){ ?>
                        <a href="#" class="btn font-xsm btn-outline-white float-l" onclick="window.open('https://iniweb.inicis.com/receipt/iniReceipt.jsp?noTid=<?=$orderInfo->tid?>','영수증조회','width=550,height=900,location=no,status=no,scrollbars=yes');">영수증조회</a>
                    <?php } ?>

                    <a onfocus=blur() href="javascript:void(window.open('<?=route_guest('orderinfo.printorderinfo', $orderInfo->info_id)?>','win0','width=1400,height=900,toolbar=no,titlebar=no,menubar=no,location=no'))" class="btn font-xsm btn-outline-white float-l ml-1" title="거래명세서 출력">거래명세서 출력</a> 

                    <a href="<?=route_guest('orderinfo')?>" class="btn font-xsm btn-blue float-r ml-1"><?=lang_contact('news_list')?></a>

                    <?php if($orderInfo->order_status == "5" || $orderInfo->order_status == "6" || $orderInfo->order_status == "7") { ?>
                    <button class="btn font-xsm btn-blue float-r" type="button" onclick="return info_chk1(this.form);"><?=lang_orderinfo('refund')?></button>
                    <?php } ?>
                    
                    <?php if ($orderInfo->order_status == "1" || $orderInfo->order_status == "2" || $orderInfo->order_status == "3" || $orderInfo->order_status == "14" ) {?>
                    <button class="btn font-xsm btn-blue float-r" type="button" onclick="return info_chk2(this.form);">정보변경</button>
                    <?php } ?>

                </div>
        </form>
        <?php } ?>

    <script src="//t1.daumcdn.net/mapjsapi/bundle/postcode/prod/postcode.v2.js"></script>
    <script>
        function sample6_execDaumPostcode() {
            new daum.Postcode({
                oncomplete: function(data) {
                    var addr = ''; // 주소 변수
                    var extraAddr = ''; // 참고항목 변수
                    
                    if (data.userSelectedType === 'R') { // 사용자가 도로명 주소를 선택했을 경우
                        addr = data.roadAddress;
                    } else { // 사용자가 지번 주소를 선택했을 경우(J)
                        addr = data.jibunAddress;
                    }

                    if(data.userSelectedType === 'R'){
                        if(data.bname !== '' && /[동|로|가]$/g.test(data.bname)){
                            extraAddr += data.bname;
                        }

                        if(data.buildingName !== '' && data.apartment === 'Y'){
                            extraAddr += (extraAddr !== '' ? ', ' + data.buildingName : data.buildingName);
                        }

                        if(extraAddr !== ''){
                            extraAddr = ' (' + extraAddr + ')';
                        }

                        document.getElementById("shipping_add2").value = extraAddr;                    
                    } else {
                        document.getElementById("shipping_add2").value = '';
                    }
                    document.getElementById('shipping_zipocode').value = data.zonecode;
                    document.getElementById("shipping_add1").value = addr;
                    document.getElementById("shipping_add2").focus();
                }
            }).open();
        }
    </script>

    <script src="<?=asset_guest_js('sweetalert.min.js')?>"></script>
    <script>
        $(document).ready(function () {        
            <?php if(session()->getFlashdata('status')) {?>
                swal({
                    title: "<?=session()->getFlashdata('status')?>",
                    text: "<?=session()->getFlashdata('status_text')?>",
                    icon: "<?=session()->getFlashdata('status_icon')?>",
                    buttons: "확인"
                });
            <?Php } ?>
        });
    </script>

</section>
<!---------------------------------------------------------------------------------------------->
<script>
	$(function () {        
        $('.myMenu ul li').on('mouseenter mouseleave', function () {
            $(this).children('ul').stop(true, false, true).slideToggle(10);
        });
    });

    $(document).ready(function() {
        $('.category-toggle').click(function() {
            $('.category-box').slideToggle(300); // 슬라이드 애니메이션 효과로 펼치고 접기
            $(this).toggleClass('on');
        });
    });

    /* prd category */    
    $(".prd_cate_item a").click(function(){
        $(".prd_cate_item a").removeClass("active");
        //this는 함수를 실행하게 만든 그 클릭한 요소다!
        $(this).addClass("active");//그 요소에게 효과주고        
    });

    /* 상품 정렬 */
    $(".align-item a").click(function(){
        $(".align-item a").removeClass("active");
        //this는 함수를 실행하게 만든 그 클릭한 요소다!
        $(this).addClass("active");//그 요소에게 효과주고        
    });
    
</script>
<!---------------------------------------------------------------------------------------------->

<?= $this->endSection() ?>
