<?= $this->extend('guest/layouts/master') ?>

<?= $this->section('head.title') ?>
    <?=lang_refundinfo('title')?>
<?= $this->endSection() ?>

<?= $this->section('body.breadcrumb')?>
 
<?=$this->endSection()?>

<?= $this->section('content') ?>
<!--#siteMain-->
<!-- product details top info s -->
<section class="sub_wrap">
    <div class="content_wrap prd-list-wrap">
<!------------------------------------------------------------------------------------------------------------------->

        <nav class="breadcrumb" style='background-color: #ffffff;'>
            <ul>
            <li><a href='<?=route_guest('home')?>'><img src='<?=asset_public('images/ico-home.png')?>' alt=''></a></li>
            <li><a href="#">마이페이지</a></li>
                <li><a href="#"><?=lang_refundinfo('title')?></a></li>                
            </ul>            
        </nav>

        <div class="prd-category mt-2">            
            <select name="" id="" class="prd-cate-mo">
                <option value=""><a href="<?=route_guest('one2one')?>">1:1 상담</a></option>
                <option value=""><a href="<?=route_guest('inquiry')?>">상품문의</a></option>
                <option value=""><a href="<?=route_guest('estimate')?>">견적문의</a></option>
                <!--option value=""><a href="<?=route_guest('deferredpay')?>">후불문의</a></option-->
                <option value=""><a href="<?=route_guest('orderinfo')?>">주문내역</a></option>
                <!--option value=""><a href="<?=route_guest('review')?>">상품후기</a></option-->
                <option value=""><a href="<?=route_guest('refundinfo')?>">반품문의</a></option>
                <!--option value=""><a href="<?=route_guest('news')?>">공지사항</a></option-->
            </select>

            <div class="prd-cate-pc">
                <div class="category-toggle">                
                마이페이지
                </div>
                <div class="category-box">
                    <ul>
                        <li class="prd_cate_item"><a href="<?=route_guest('one2one')?>">1:1 상담</a></li>
                        <li class="prd_cate_item"><a href="<?=route_guest('inquiry')?>">상품문의</a></li>
                        <li class="prd_cate_item"><a href="<?=route_guest('estimate')?>">견적문의</a></li>
                        <!--li class="prd_cate_item"><a href="<?=route_guest('deferredpay')?>">후불문의</a></li-->
                        <li class="prd_cate_item"><a href="<?=route_guest('orderinfo')?>">주문내역</a></li>
                        <!--li class="prd_cate_item"><a href="<?=route_guest('review')?>">상품후기</a></li-->
                        <li class="prd_cate_item"><a href="<?=route_guest('refundinfo')?>" class="active">반품문의</a></li>
                        <!--li class="prd_cate_item"><a href="<?=route_guest('news')?>">공지사항</a></li-->
                    </ul>
                </div>
            </div>
        </div>

        <!-- 주문 상품정보 s -->
        <div class="border-light-box">
        <div class="sub_title"><?=lang_refundinfo('title')?></div>

        <div class="order-form">
            <div class="form-gp">
                <div class="d-flex g-2">
                    <div style="width: 100%;">
                        <form method="get" action="<?=route_guest('refundinfo')?>">
                        <input placeholder="<?=lang_refundinfo('title')?> 검색" name="title" value="<?=$title?>" style="width: 80%;">
                        <button type="submit" class="btn font-xsm btn-outline-white float-r">검색</button>
                        </form>
                    </div>
                </div>
                <div class="d-flex g-2">

                </div>
            </div>
        </div>

        <div class="prd-linelist">
        <table>
            <thead>
                <tr>
                    <td class="info1"><?=lang_contact('news_no')?></td>
                    <td class="info2">접수일시</td>
                    <td class="desc"><?=lang_refundinfo('refund_code')?></td>
                    <td class="info2">주문번호</td>
                    <td class="desc">주문내역</td>
                    <td class="info2">환불금액</td>
                    <td class="desc">처리상태</td>
                </tr>
                </tr>
            </thead>
            <tbody>

                <?php foreach ($lists as $key => $item): ?>
                    <tr>
                        <td data-label="<?=lang_contact('news_no')?>" class="info1"><?=show_no_row($key+1, $perPage, $currentPage)?></td>
                        <td data-label="접수일시" class="info2"><?=\App\Helpers\DateHelper::toTimeString($item->created_at,'yyyy-MM-dd hh:mm')?></td>
                        <td data-label="<?=lang_refundinfo('refund_code')?>" class="desc"><a href="<?=route_guest('refundinfo.detail', $item->info_id)?>"><?=$item->refund_code?></a></td>
                        <td data-label="주문번호" class="info2"><?=$item->order_code?></td>
                        <td data-label="주문내역" class="desc"><?=$item->firstitem_number?> 외 <?=$item->item_counts?></td>
                        <td data-label="환불금액" class="info2"><?=\App\Helpers\NumberHelper::format($item->amount_total, true)?><?=lang_sale('price_unit')?></td>
                        <td data-label="처리상태" class="desc">
                        <?php 
                        if($item->return_status ==1) {
                            echo "신청";
                        } elseif ($item->return_status ==2){
                            echo "처리중";
                        } elseif ($item->return_status ==3){
                            echo "완료";
                        } else {
                            echo "신청";
                        }
                        ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
                <?php if(count($lists) == 0): ?>
                    <tr>
                        <td colspan="7"><?=lang_common('no_data')?></td>
                    </tr>
                <?php endif;?>
                </tbody>
            </table>
        </div>

<!----------------------------------------------------------------------------------------------->
</div>
<!----------------------------------------------------------------------------------------------->

    <div class="row">
        <div class="col-12">
            <?= $pager->links() ?>
        </div>
    </div>

</section>
<!--product details top info e-->
<!--/#siteMain-->
<!---------------------------------------------------------------------------------------------->
<script>
	$(function () {        
        $('.myMenu ul li').on('mouseenter mouseleave', function () {
            $(this).children('ul').stop(true, false, true).slideToggle(10);
        });
    });

    $(document).ready(function() {
        $('.category-toggle').click(function() {
            $('.category-box').slideToggle(300); // 슬라이드 애니메이션 효과로 펼치고 접기
            $(this).toggleClass('on');
        });
    });

    /* prd category */    
    $(".prd_cate_item a").click(function(){
        $(".prd_cate_item a").removeClass("active");
        //this는 함수를 실행하게 만든 그 클릭한 요소다!
        $(this).addClass("active");//그 요소에게 효과주고        
    });

    /* 상품 정렬 */
    $(".align-item a").click(function(){
        $(".align-item a").removeClass("active");
        //this는 함수를 실행하게 만든 그 클릭한 요소다!
        $(this).addClass("active");//그 요소에게 효과주고        
    });
    
</script>
<!---------------------------------------------------------------------------------------------->

<?= $this->endSection() ?>
