<?php
use App\Helpers\AuthHelpers;
?>

<?= $this->extend('guest/layouts/master') ?>

<?= $this->section('head.title') ?>
    <?=$item->title?>
<?= $this->endSection() ?>

<?= $this->section('body.breadcrumb')?>

<?=$this->endSection()?>

<?= $this->section('content') ?>
<!--#siteMain-->

<!-- product details top info s -->
<section class="sub_wrap">
    <div class="content_wrap">
<!------------------------------------------------------------------------------------------------------------------->

        <nav class="breadcrumb" style='background-color: #ffffff;'>
            <ul>
            <li><a href='<?=route_guest('home')?>'><img src='<?=asset_public('images/ico-home.png')?>' alt=''></a></li>
            <li><a href="#">마이페이지</a></li>
                <li><a href="#"><?=lang_refundinfo('title')?></a></li>                
            </ul>            
        </nav>

        <div class="prd-category mt-2">            
            <select name="" id="" class="prd-cate-mo">
                <option value=""><a href="<?=route_guest('one2one')?>">1:1 상담</a></option>
                <option value=""><a href="<?=route_guest('inquiry')?>">상품문의</a></option>
                <option value=""><a href="<?=route_guest('estimate')?>">견적문의</a></option>
                <!--option value=""><a href="<?=route_guest('deferredpay')?>">후불문의</a></option-->
                <option value=""><a href="<?=route_guest('orderinfo')?>">주문내역</a></option>
                <!--option value=""><a href="<?=route_guest('review')?>">상품후기</a></option-->
                <option value=""><a href="<?=route_guest('refundinfo')?>">반품문의</a></option>
                <!--option value=""><a href="<?=route_guest('news')?>">공지사항</a></option-->
            </select>

            <div class="prd-cate-pc">
                <div class="category-toggle">                
                마이페이지
                </div>
                <div class="category-box">
                    <ul>
                        <li class="prd_cate_item"><a href="<?=route_guest('one2one')?>">1:1 상담</a></li>
                        <li class="prd_cate_item"><a href="<?=route_guest('inquiry')?>">상품문의</a></li>
                        <li class="prd_cate_item"><a href="<?=route_guest('estimate')?>">견적문의</a></li>
                        <!--li class="prd_cate_item"><a href="<?=route_guest('deferredpay')?>">후불문의</a></li-->
                        <li class="prd_cate_item"><a href="<?=route_guest('orderinfo')?>">주문내역</a></li>
                        <!--li class="prd_cate_item"><a href="<?=route_guest('review')?>">상품후기</a></li-->
                        <li class="prd_cate_item"><a href="<?=route_guest('refundinfo')?>" class="active">반품문의</a></li>
                        <!--li class="prd_cate_item"><a href="<?=route_guest('news')?>">공지사항</a></li-->
                    </ul>
                </div>
            </div>
        </div>

<!------------------------------------------------------------------------------------------------------------------->


    <?php if ($refundInfo->member_code != AuthHelpers::getLoginInfoGuest()->member_code ) {?>
    
    <script src="<?=asset_guest_js('sweetalert.min.js')?>"></script>
    <script>
        $(document).ready(function () {
    
            swal({
                title: "정보오류",
                text: "회원정보가 없거나 일치하지 않습니다.",
                icon: "warning",
                button: "확인",
            })
            .then(function(){
                location.href = "/refundinfo";
            });
    
        });
    </script>
    <?php } else {?>

    <form method="post" action="<?=route_guest('refundinfo.create')?>" enctype="multipart/form-data" id="form">
    <input type="hidden" name="info_id" value="<?=$refundInfo->info_id?>"/>
    <input type="hidden" name="refund_code" value="<?=$refundInfo->refund_code?>"/>

    <div class="order_ListTdWrap">
                <?php if (!$lists) :?>

                    <div class="border-light-box order-form">
                    <div class="sub_title d-flex">반품할 상품이 없습니다.</div>
                    <div class="form-gp">
                        <div class="d-flex g-1">
                        주문내역에 반품할 상품이 선택하여 신청해 주시기 바랍니다.
                        </div>                
                    </div>
                    <div class="form-gp">
                        <div class="d-flex g-1">
                            <label for=""> </label>
                        </div>                
                    </div>
                </div>

                <div class="order-btn-box btn-lg-box btn-box align-c mt-3 mb-1">
                    <a href="<?=route_guest('home')?>"><button class="btn btn-lg btn-blue w-20 ml-1">확인</button></a>
                </div>

                <?php else: ?>

                <!-- 반품상품 s -->
                <div class="border-light-box">
                    <div class="sub_title">반품품 상품정보</div>
                    <table class="table_style2 order_list">
                        <thead>
                            <tr>
                                <th>제품사진</th>
                                <th>반품상품</th>
                                <th>단가</th>
                                <th>반품수량</th>
                                <th>공급가액(VAT)</th>
                                <th>환불금액</th>
                                <th>반품사유</th>
                            </tr>
                        </thead>
                        <tbody>

                <?php $i = 1; ?>

                <?php foreach($lists as $item){?>

                    <tr>
                        <input type="hidden" name="refund_id<?=$i?>" value="<?=$item->refund_id?>">
                        <td><p class="prd-img">
                        <?php if(isset($item->nowinfo['image_dir']) && $item->nowinfo['image_dir'] != ''): ?>
                            <?php if(isset($item->nowinfo['api_flg']) && $item->nowinfo['api_flg'] == '1'): ?>
                                <img src="<?=$item->nowinfo['image_dir']?>"/>
                            <?php else : ?>
                                <img src="<?=asset_public($item->nowinfo['image_dir'])?>"/>
                            <?php endif; ?>
                        <?php else : ?>
                            <img src="<?=asset_public('images/no_image_available.jpg')?>"/>
                        <?php endif; ?>
                        </p></td>
                        <td>
                            <p class="col-blue font-sm"><?php echo $item->manufacturer_name;?></p>
                            <p class="prd-subject"><?php echo $item->part_number;?></p>
                            <p><label class="badge_blue font-sm">
                                <?php foreach ($stocklocationcategorys as $stock_location): ?>
                                    <?php if($stock_location->location_id == $item->stock_location) echo $stock_location->location_info;?>
                                <?php endforeach; ?>
                            </label></p>
                            <p class="prd-cmt col-gray font-sm"><?=$item->nowinfo['product_code']?></p>
                            <p class="prd-option col-gray font-sm">
                                <?php
                                $brief_description = $item->nowinfo['brief_description'];
                                $prd_description = explode('|^|', $brief_description);

                                echo mb_strimwidth($prd_description[1],'0',30,'...','utf-8');
                                ?>
                            </p>
                        </td>

                        <td><?=number_format($item->price)?>원</td>
                        <td><?php echo $item->qty?></td>
                        <td><?=number_format($item->supply_price)?>원 (<?=number_format($item->vat)?>원)</td>
                        <td><?=number_format($item->amount)?>원</td>
                        <td>
                            <select class="form-control" name="refund_reason<?=$i?>">
                                    <option value="">반품사유 선택</option>
                                <?php foreach ($reasonreturninfo as $reasonreturn): ?>
                                    <option value="<?=$reasonreturn->return_id?>"><?=$reasonreturn->return_info?></option>
                                <?php endforeach; ?>
                            </select>
                        </td>
                        <?php
                        $all_qty = $all_qty + $item->qty;
                        $all_amount_price = $all_amount_price + $item->supply_price;
                        $all_price_vat = $all_price_vat + $item->vat;
                        
                        $i++; 

                        }
                        $total_all_price = $all_amount_price + $all_price_vat;
                        ?>
                        <input type="hidden" name="dataRow" value="<?=$i?>">
                    </tr>

                </tbody>
            </table> 
  <!-------------------------------------------------------------------------------------------------------------------->
                <div class="border-light-box order-form">
                    <div class="form-gp">
                        <div class="d-flex g-2">
                            <label for="">상품갯수</label>
                            <?=$all_qty?>개
                        </div>
                        <div class="d-flex g-2">
                            <label for="">합계금액</label>
                            <?=number_format($total_all_price)?>원 (VAT포함)
                        </div>
                    </div>
                </div>

            <?php endif;?>

 <!------------------------------------------------------------------------------------------------------------------->

                 <!-- 주문자 정보 s -->
                 <div class="border-light-box order-form">
                    <div class="sub_title d-flex">주문 정보</div>
                    <div class="form-gp">
                        <div class="d-flex g-1">
                            <label for="">주문번호</label>
                            <?=$refundInfo->order_code?>
                        </div>                
                    </div>
                    <div class="form-gp">
                        <div class="d-flex g-2">
                            <label for="">주문자</label>
                            <?=$refundInfo->orderer_name?>
                        </div>
                        <div class="d-flex g-2">
                            <label for="">이메일</label>
                            <?=$refundInfo->orderer_email?>
                        </div>
                    </div>
                    <div class="form-gp">
                        <div class="d-flex g-1">
                            <label for="">휴대폰</label>
                            <?=$refundInfo->orderer_phone?>
                        </div>                
                    </div>
                </div>
                <!-- 주문자 정보 e -->

                 <!-- 주문자 정보 s -->
                 <div class="border-light-box order-form">
                    <div class="sub_title d-flex">반품 신청정보</div>
                    <div class="form-gp">
                        <div class="d-flex g-1">
                            <label for="">반품방법</label>
                            <label class="input-container ml-1">택배
                                <input type="radio" name="return_shipping" id="return_shipping" value="1" checked="checked">
                                <span class="checkmark"></span>
                            </label>
                            <label class="input-container ml-1">화물
                                <input type="radio" name="return_shipping" id="return_shipping" value="2">
                                <span class="checkmark"></span>
                            </label>
                            <label class="input-container ml-1">방문
                                <input type="radio" name="return_shipping" id="return_shipping" value="3">
                                <span class="checkmark"></span>
                            </label>
                        </div>                
                    </div>

                    <div class="form-gp">
                        <div class="d-flex g-1">
                            <label for="">배송비 입금계좌</label>
                            은행명: 하나은행 계좌번호: 138-910044-11204 예금주: 주식회사셀파세미컴
                        </div>                
                    </div>
                    <div class="form-gp">
                        <div class="d-flex g-1">
                            <label for="">반품배송비</label>
                            반품 상품 회수로 인하여 발생될 배송비는 관리자가 결정해 드립니다.
                        </div>                
                    </div>
                </div>

                 <!-- 배송지 정보 s -->
                <div class="border-light-box order-form">
                    <div class="sub_title d-flex">배송지 정보</div>
                    <div class="form-gp">
                        <div class="d-flex g-2">
                            <label for="">받는분</label>
                            <?=$refundInfo->shipping_name?>
                        </div>
                        <div class="d-flex g-2">
                            <label for="">휴대폰</label>
                            <?=$refundInfo->shipping_phone?>
                        </div>
                    </div>
                    <div class="form-gp">
                        <div class="d-flex g-2">
                            <label for="">회사명</label>
                            <?=$refundInfo->company_name?>
                        </div> 
                        <div class="d-flex g-2">
                            <label for="">전화번호</label>
                            <?=$refundInfo->delivery_phone?>
                        </div>                
                    </div>
                    <div class="form-gp">
                        <div class="d-flex g-2">
                            <label for="">우편번호</label>
                            <div class="group-btn d-flex">
                            <input id="return_zipocode" type="text" name="return_zipocode" value="<?=$refundInfo->shipping_zipocode?>" placeholder="우편번호">
                            <input type="button" onclick="sample6_execDaumPostcode()" value="우편번호 찾기" class="btn btn-gray ml-1">
                            </div>
                        </div>
                        <div class="d-flex g-2"> </div>
                    </div>
                    <div class="form-gp">                
                        <div class="d-flex g-1">
                            <label for="">배송지</label>
                            <input id="return_add1" type="text" name="return_add1" value="<?=$refundInfo->shipping_add1?>" placeholder="주소" required>
                        </div>
                    </div>
                    <div class="form-gp">                
                        <div class="d-flex g-1">
                            <label for="">배송지 상세</label>
                            <input id="return_add2" type="text" name="return_add2" value="<?=$refundInfo->shipping_add2?>" placeholder="상세주소">
                        </div>
                    </div>
                </div>
                <!-- 배송지 정보 e -->

                <!-- 반품사유 s -->
                <div class="border-light-box order-form">
                    <div class="sub_title d-flex">반품사유 정보</div>                    
                    <div class="form-gp">                
                        <div class="d-flex g-1">
                            <label for="">반품사유</label>
                            <select class="form-control" name="refund_reason">
                                <option value="">반품사유 선택</option>
                                <?php foreach ($reasonreturninfo as $reasonreturn): ?>
                                <option value="<?=$reasonreturn->return_id?>"><?=$reasonreturn->return_info?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                    <div class="form-gp">
                        <div class="d-flex g-1">
                            <label for="">반품 상세사유</label>
                            <textarea class="form-control" id="content" name="content" rows="8"></textarea>
                        </div>
                    </div>
                </div>
                <!-- 반품사유 e -->

        <?php } ?>
            </div>

            <div class="order-btn-box mt-3 mb-2"> </div>
            <div class="order-btn-box btn-lg-box btn-box align-c">
                <button type="submit" class="btn btn-lg btn-blue w-20 ml-1"><?=lang_common('create')?></button>
            </div>
            
        </form>

<!---------------------------------------------------------------------------------------------------------------->
    </div>
</section>
<!-- product details top info e -->
<!--/#siteMain-->
<!---------------------------------------------------------------------------------------------------------------->

<script src="//t1.daumcdn.net/mapjsapi/bundle/postcode/prod/postcode.v2.js"></script>
    <script>
        function sample6_execDaumPostcode() {
            new daum.Postcode({
                oncomplete: function(data) {
                    var addr = ''; // 주소 변수
                    var extraAddr = ''; // 참고항목 변수
                    
                    if (data.userSelectedType === 'R') { // 사용자가 도로명 주소를 선택했을 경우
                        addr = data.roadAddress;
                    } else { // 사용자가 지번 주소를 선택했을 경우(J)
                        addr = data.jibunAddress;
                    }

                    if(data.userSelectedType === 'R'){
                        if(data.bname !== '' && /[동|로|가]$/g.test(data.bname)){
                            extraAddr += data.bname;
                        }

                        if(data.buildingName !== '' && data.apartment === 'Y'){
                            extraAddr += (extraAddr !== '' ? ', ' + data.buildingName : data.buildingName);
                        }

                        if(extraAddr !== ''){
                            extraAddr = ' (' + extraAddr + ')';
                        }

                        document.getElementById("return_add2").value = extraAddr;                    
                    } else {
                        document.getElementById("return_add2").value = '';
                    }
                    document.getElementById('return_zipocode').value = data.zonecode;
                    document.getElementById("return_add1").value = addr;
                    document.getElementById("return_add2").focus();
                }
            }).open();
        }
    </script>

<!---------------------------------------------------------------------------------------------->
<script>
	$(function () {        
        $('.myMenu ul li').on('mouseenter mouseleave', function () {
            $(this).children('ul').stop(true, false, true).slideToggle(10);
        });
    });

    $(document).ready(function() {
        $('.category-toggle').click(function() {
            $('.category-box').slideToggle(300); // 슬라이드 애니메이션 효과로 펼치고 접기
            $(this).toggleClass('on');
        });
    });

    /* prd category */    
    $(".prd_cate_item a").click(function(){
        $(".prd_cate_item a").removeClass("active");
        //this는 함수를 실행하게 만든 그 클릭한 요소다!
        $(this).addClass("active");//그 요소에게 효과주고        
    });

    /* 상품 정렬 */
    $(".align-item a").click(function(){
        $(".align-item a").removeClass("active");
        //this는 함수를 실행하게 만든 그 클릭한 요소다!
        $(this).addClass("active");//그 요소에게 효과주고        
    });
    
</script>
<!---------------------------------------------------------------------------------------------->

<?= $this->endSection() ?>
