<?= $this->extend('guest/layouts/master') ?>

<?= $this->section('head.title') ?>
    <?=lang_sale('inquiry')?>
<?= $this->endSection() ?>

<?= $this->section('body.js') ?>
    <script type="text/javascript">
        $(document).ready(function () {
            $('#regulation').on('scroll', function () {
                regulationScroll();
            });
            $('#agree').on('change',function () {
                if($(this).is(":checked")){
                    $('#btn-submit').removeAttr('disabled');
                }else{
                    $('#btn-submit').attr('disabled','disabled');
                }
            });
            regulationScroll();
        });
        function regulationScroll() {
            let offset = 50;
            let regulation = $('#regulation');
            let top = regulation.offset().top;
            let height = regulation.height()
            let bottom = top + height
            if(bottom <= top + height){
                $('#agree').removeAttr('disabled');
            }else{
                if (regulation.scrollTop()  >= $('#regulation').height() - offset) {
                    $('#agree').removeAttr('disabled');
                }
            }
        }
    </script>

    <script src="<?=asset_guest_js('bootstrap-input-spinner.js')?>"></script>
    <script>
        $("input[type='number']").inputSpinner();
        CartJS.init();
    </script>
<?= $this->endSection() ?>

<?= $this->section('content') ?>

    <!--#Breadcrumb-->
    <?=$breadcrumb->render('guest.sale.inquiry')?>

    <section id="siteMain" class="site-main">
        <div class="container">
        <h2 class="form-title"><?=lang_sale('inquiry')?></h2>
            <div class="form form-contact mb-5">
                <?php if($session->has('message')): ?>
                    <div class="alert alert-success">
                        <?=$session->get('message')?>
                    </div>
                <?php endif;?>

                <form id="form" action="<?=route_guest('sale.inquiry.create')?>" method="post">
                <input type="hidden" name="item_id" value="<?=old_value('item_id', $item_id)?>"/>
            <ul class="cart-list">
                <li class="title">
                    <div class="estimate_part_number"><?=lang_cart('part_number')?></div>
                    <div class="estimate_manufacturer"><?=lang_cart('manufacturer')?></div>
                    <!--div class="estimate_stock"><? #=lang_cart('stock')?></div-->
                    <div class="estimate_quantity"><?=lang_cart('qty')?></div>
                    <div class="estimate_price"><?=lang_cart('price')?></div>
                </li>
                    <li class="cart" data-id="<?=$item->item_id?>">
                        <div class="estimate_part_number">
                        <input id="name" type="text" class="form-control" name="part_number" value="<?=old_value('part_number', $part_number)?>"
                        placeholder="<?=lang_cart('part_number')?>" aria-describedby="part_number"/>
                        </div>
                        <div class="estimate_manufacturer">
                        <input id="name" type="text" class="form-control" name="name" value="<?=old_value('name', $name)?>"
                        placeholder="<?=lang_cart('manufacturer')?>" aria-describedby="name"/>
                        </div>
                        <!--div class="estimate_stock">
                        <? #=old_value('qty', $qty)?>
                        </div-->
                        <div class="estimate_quantity">
                            <input type="number" name="qty" value="1" min="1" max="100000" step="1"/>
                        </div>
                        <div class="estimate_price">
                            <input type="text" class="double text-right form-control" name="price" value="0" min="0" max="9000000" maximumFractionDigits="5"/>
                        </div>
                    </li>
            </ul>

                    <div class="form-group">
                        <label class="form-label" for="name">
                            <?=lang_sale('inquiry_name')?>
                            <code>*</code>
                        </label>
                        <input id="name" type="text" class="form-control" name="name" value="<?=old_value('name', $memberName)?>"
                               placeholder="<?=lang_sale('inquiry_name')?>" aria-describedby="name"/>
                    </div>
                    <div class="form-group">
                        <label class="form-label" for="email">
                            <?=lang_sale('inquiry_email')?>
                            <code>*</code>
                        </label>
                        <input id="email" type="email" class="form-control" name="email" value="<?=old_value('email',$memberEmail)?>"
                               placeholder="<?=lang_sale('inquiry_email')?>" aria-describedby="email"/>
                    </div>
                    <div class="form-group">
                        <label class="form-label" for="tel">
                            <?=lang_sale('inquiry_tel')?>
                            <code>*</code>
                        </label>
                        <input id="tel" type="tel" class="form-control" name="tel" value="<?=old('tel')?>"
                               placeholder="<?=lang_sale('inquiry_tel')?>"/>
                    </div>
                    <div class="form-group">
                        <label class="form-label" for="inquiry_title">
                            <?=lang_sale('inquiry_title')?>
                            <code>*</code>
                        </label>
                        <input id="title" type="text" class="form-control" name="title" value="<?=old('title')?>"
                               placeholder="<?=lang_sale('inquiry_title')?>" aria-describedby="title"/>
                    </div>
                    <div class="form-group">
                        <label class="form-label" for="memo_content">
                            <?=lang_sale('inquiry_memo')?>
                            <code>*</code>
                        </label>
                        <textarea id="memo_content" class="form-control" name="memo_content"
                                  placeholder="<?=lang_sale('inquiry_memo')?>" rows="5"></textarea>
                    </div>
                    <div class="form-group">
                        <textarea id="regulation" class="form-control" rows="5">
당사는 고객님의 개인정보를 중요시하며, "정보통신망 이용촉진 및 정보보호"에 관한 법률을 준수하고 있습니다.
당사는 고객님에게 수집하는 개인정보의 항목, 개인정보의 수집 및 이용목적, 개인정보의 보유 및 이용 기간을 안내해 드리며 동의 여부를 체크해 주시기 바랍니다.
수집에 동의하지 않는다면 문의가 제한됩니다.

수집하는 개인정보 항목
이름, 이메일, 휴대전화번호
개인정보의 수집 및 이용 목적
이름, 이메일, 휴대전화: 문의 사항에 대한 답변을 전달하기 위한 의사소통 경로의 확보
개인정보의 보유 및 이용 기간
원칙적으로 개인정보의 수집∙이용 목적 달성 시 바로 파기합니다.
수집∙이용 목적을 달성한 경우에도 법률의 규정에 따라 보존할 필요가 있다면 고객의 개인정보를 보유할 수 있습니다.
- 계약 또는 청약 철회 등에 관한 기록 : 5년
- 대금결제 및 재화 등의 공급에 관한 기록 : 5년
- 소비자의 불만 또는 분쟁 처리에 관한 기록 : 3년 등
                        </textarea>
                    </div>
                    <div class="form-group">
                        <div class="form-check">
                            <input disabled <?=!empty(old('agree')) ? 'checked': ''?> class="form-check-input" type="checkbox" name="agree" value="1" id="agree">
                            <label class="form-check-label" for="agree"><?=lang_sale('inquiry_label_checked')?></label>
                        </div>
                    </div>

                    <div class="form-action">
                        <button type="submit" class="btn btn-submit btn-login w-100" id="btn-submit" disabled name="submit">
                            <?=lang_sale('inquiry_send')?>
                        </button>
                    </div>

                </form>
            </div>
        </div>
    </section>
<?= $this->endSection() ?>
