<?= $this->extend('guest/layouts/master') ?>

<?= $this->section('head.title') ?>
    <?=lang_contact('inquiry')?>
<?= $this->endSection() ?>

<?= $this->section('body.js') ?>
    <script type="text/javascript">
        $(document).ready(function () {
            $('#regulation').on('scroll', function () {
                regulationScroll();
            });
            $('#agree').on('change',function () {
                if($(this).is(":checked")){
                    $('#btn-submit').removeAttr('disabled');
                }else{
                    $('#btn-submit').attr('disabled','disabled');
                }
            });
            regulationScroll();
        });
        function regulationScroll() {
            let offset = 50;
            let regulation = $('#regulation');
            let top = regulation.offset().top;
            let height = regulation.height()
            let bottom = top + height
            if(bottom <= top + height){
                $('#agree').removeAttr('disabled');
            }else{
                if (regulation.scrollTop()  >= $('#regulation').height() - offset) {
                    $('#agree').removeAttr('disabled');
                }
            }
        }
    </script>
<?= $this->endSection() ?>

<?= $this->section('content') ?>

    <!--#Breadcrumb-->
    <?=$breadcrumb->render('guest.sale.inquiry')?>

    <section id="siteMain" class="site-main">
        <div class="container">
        <h2 class="form-title"><?=lang_contact('inquiry')?></h2>

        <div class="form-login">
            <?php if($session->has('message')): ?>
                <div class="alert alert-success">
                    <?=$session->get('message')?>
                </div>
            <?php endif; ?>

            <!--h2 class="form-title"><?=lang_contact('inquiry')?></h2-->
            <form action="<?=route_guest('sale.index')?>">
                <div class="form-action">
                    <button type="submit" class="btn btn-submit btn-login w-100" name="submit"><?=lang_sale('list_title')?></button>
                </div>
            </form>

                <div class="form-link text-center">
                    <p><a class="link-register" href="<?=route_guest('home')?>"><?=lang_common('home')?></a></p>
                </div>

        </div>
    </div>

    </section>

<?= $this->endSection() ?>
