if ((typeof CartJS) === 'undefined') { CartJS = {}; }

let buttonAddCart = $('.btn-add-cart');
let inputQty = $('input[name=qty]');
let inputPrice = $('input[name=price]');
let urlCart = '';
let urlChangeQty = $('input[name=url_change_qty]').val();
let urlChangePrice = $('input[name=url_change_price]').val();
let checkBoxAll = $('input[name=check_all]');
let btnCheckQuote = $('.btn-check-quote');
let btnAllQuote = $('.btn-all-quote');
let btnQuantityDetail = $('input[name=quantity]');
let currentQuantityDetail;

CartJS.init = function () {
    $(document).ready(function() {
        buttonAddCart.on('click', function () {
            let url = $(this).attr('data-action');
            let itemId = $(this).attr('data-id');
            let urlLogin = $(this).attr('data-url-login');
            urlCart = $(this).attr('data-url-cart');
            let isLogin = $('input[name=is_login]').val();
            if(isLogin == 0){
                window.location = urlLogin;
            }else {
                let quantity = $('input[name=quantity]').val();
                let price = $('input[name=target_price]').val();
                let memo = $('textarea[name=memo_content]').val();
                price = InputFortmat.originalDouble(price);
                quantity = InputFortmat.originalNumber(quantity);
                CartJS.addCart(itemId, url, urlLogin, quantity, price, memo);
            }
        });
        inputQty.on('change', function () {
            let itemId = $(this).closest('li').find('input[name=check_box]').val();
            let qty = $(this).val();
            qty = InputFortmat.originalNumber(qty);
            CartJS.changeQty(itemId, qty);
        });
        inputPrice.on('change', function () {
            let itemId = $(this).closest('li').find('input[name=check_box]').val();
            let price = $(this).val();
            price = InputFortmat.originalDouble(price);
            CartJS.changePrice(itemId, price);
        });
        btnCheckQuote.addClass('disabled');
        checkBoxAll.on('change',function () {
            CartJS.checkAll(this);
        });
        $('input[name=check_box]').on('change',function () {
            CartJS.checkItem(this);
        });
        btnCheckQuote.on('click',function () {
            CartJS.createQuoteAction(this);
        });
        btnAllQuote.on('click',function () {
            CartJS.createQuoteAction(this);
        });
        btnQuantityDetail.on('change',function () {
            let value = $(this).val();
            let maxValue = $(this).attr('max');
            if(value >= maxValue && ( currentQuantityDetail == null || value == currentQuantityDetail)){
                $('#quantity-error').removeClass('hide');
            }else{
                $('#quantity-error').addClass('hide');
            }
            currentQuantityDetail = value;
        });
    });
}

CartJS.addCart = function (itemId, url, urlLogin, quantity, price) {
    let data = 'item_id=' + itemId + '&quantity='+quantity+"&price="+price;
    let params = {
            type: 'GET',
            url: url,
            data: data,
            dataType: 'json',
            beforeSend: function() {
                // $body.trigger('beforeUpdateCartNote.ajaxCart', note);
                ModalJS.showLoading();
            },
            success: function(data) {
                let status = data.status;
                switch (status) {
                    case -1:
                        window.location = urlLogin;
                        break;
                    case 0://Success
                        $('span.count-cart').html(data.countCart);
                        ModalJS.showSuccess('Confirm Cart','Successfully added. Move to cart ', '', CartJS.addCartOk);
                        break;
                    case 1://Error
                        ModalJS.showDanger('Alter Error',data.message, '', CartJS.addCartOk);
                        break;
                }
            },
            error: function(XMLHttpRequest, textStatus) {
            },
            complete: function(jqxhr, text) {
                // $body.trigger('completeUpdateCartNote.ajaxCart', [this, jqxhr, text]);
                ModalJS.hideLoading();
            }
        };
    jQuery.ajax(params);
}

CartJS.addCartOk = function () {
    if(urlCart != ''){
        window.location = urlCart;
    }
}

CartJS.changeQty = function (itemId, qty) {
    let data = 'item_id=' + itemId + '&qty='+qty;
    let params = {
        type: 'POST',
        url: urlChangeQty,
        data: data,
        dataType: 'json',
        beforeSend: function() {
            // ModalJS.showLoading();
        },
        success: function(data) {
            let status = data.status;
            if(status == 0){
                $('span.count-cart').html(data.qty_total);
                CartJS.callbackChangeItem(itemId, data);
            }
        },
        error: function(XMLHttpRequest, textStatus) {
        },
        complete: function(jqxhr, text) {
            // ModalJS.hideLoading();
        }
    };
    jQuery.ajax(params);
}

CartJS.changePrice = function (itemId, price) {
    let data = 'item_id=' + itemId + '&price='+price;
    let params = {
        type: 'POST',
        url: urlChangePrice,
        data: data,
        dataType: 'json',
        beforeSend: function() {
            // ModalJS.showLoading();
        },
        success: function(data) {
            let status = data.status;
            if(status == 0){
                CartJS.callbackChangeItem(itemId, data);
            }

        },
        error: function(XMLHttpRequest, textStatus) {
        },
        complete: function(jqxhr, text) {
            // ModalJS.hideLoading();
        }
    };
    jQuery.ajax(params);
}

CartJS.callbackChangeItem = function (itemId, cartJson) {
    if(cartJson !== undefined){
        let item = eval("cartJson.items.I" + itemId);
        let rowItem = $('li[data-id='+ itemId + ']');
        rowItem.find('.cart_amount').html(item.amount);
        $('.amount_item').html(cartJson.amount);
        $('.amount_vat').html(cartJson.amount_vat);
        $('.amount_total').html(cartJson.amount_total);
    }
}

CartJS.checkAll = function (item) {
    let checked = $(item).is(":checked");
    $(item).closest('ul').find('input[name=check_box]').prop('checked',checked);
    CartJS.checkEnableCheckQuoteButton();
}

CartJS.checkItem = function (item){
    let checked = $(item).is(":checked");
    if(!checked && checkBoxAll.is(":checked")) checkBoxAll.prop('checked',false);
    CartJS.checkEnableCheckQuoteButton();
}

CartJS.checkEnableCheckQuoteButton = function(){
    var isCheck = false;
    checkBoxAll.closest('ul').find('input[name=check_box]').each(function () {
        if($(this).is(":checked")){
            isCheck = true;
        }
    });
    if(!isCheck) {
        btnCheckQuote.addClass('disabled');
    }
    else {
        btnCheckQuote.removeClass('disabled');
    }
}

CartJS.checkQuoteAction = function(){
    let partNumbers = [];
    checkBoxAll.closest('ul').find('input[name=check_box]').each(function () {
        if($(this).is(":checked")){
            partNumbers.push($(this).val());
        }
    });
    if(partNumbers.length > 0){
        var strIds = partNumbers.join(',');
        var dataUrl = btnCheckQuote.attr('data-url');
        window.location = dataUrl + strIds;
    }
}

CartJS.allQuoteAction = function () {
    var dataUrl = btnAllQuote.attr('data-url');
    window.location = dataUrl;
}

CartJS.createQuoteAction = function (btnSubmit) {
    let type = $(btnSubmit).attr('data-type');
    let form = $('form#frm-cart');
    $('input[name=cart_type]').val(type);
    if( type == '1'){
        let partNumbers = [];
        checkBoxAll.closest('ul').find('input[name=check_box]').each(function () {
            if($(this).is(":checked")){
                partNumbers.push($(this).val());
            }
        });
        if(partNumbers.length > 0){
            var strIds = partNumbers.join(',');
            $('input[name=str_ids]').val(strIds);
            form.submit();
        }
    }else if(type == '2'){
        form.submit();
    }
}